extends Node
class_name StatusIndicator

## Application status indicator (aka notification area icon).
## [b]Note:[/b] Status indicator is implemented on macOS and Windows.


## Emitted when the status indicator is pressed.
signal pressed(mouse_button: int, mouse_position: Vector2i)

## Status indicator icon.
var icon: Texture2D:
	get = get_icon, set = set_icon

## Status indicator native popup menu. If this is set, the [signal pressed] signal is not emitted.
## [b]Note:[/b] Native popup is only supported if [NativeMenu] supports [constant NativeMenu.FEATURE_POPUP_MENU] feature.
var menu: NodePath:
	get = get_menu, set = set_menu

## Status indicator tooltip.
var tooltip: String:
	get = get_tooltip, set = set_tooltip

## If [code]true[/code], the status indicator is visible.
var visible: bool:
	get = is_visible, set = set_visible



## Returns the status indicator rectangle in screen coordinates. If this status indicator is not visible, returns an empty [Rect2].
func get_rect() -> Rect2:
	pass;


func get_icon() -> Texture2D:
	return icon

func set_icon(value: Texture2D) -> void:
	icon = value

func get_menu() -> NodePath:
	return menu

func set_menu(value: NodePath) -> void:
	menu = value

func get_tooltip() -> String:
	return tooltip

func set_tooltip(value: String) -> void:
	tooltip = value

func is_visible() -> bool:
	return visible

func set_visible(value: bool) -> void:
	visible = value

