extends PhysicsBody2D
class_name StaticBody2D

## A 2D physics body that can't be moved by external forces. When moved manually, it doesn't affect other bodies in its path.
##
## A static 2D physics body. It can't be moved by external forces or contacts, but can be moved manually by other means such as code, [AnimationMixer]s (with [member AnimationMixer.callback_mode_process] set to [constant AnimationMixer.ANIMATION_CALLBACK_MODE_PROCESS_PHYSICS]), and [RemoteTransform2D].
## When [StaticBody2D] is moved, it is teleported to its new position without affecting other physics bodies in its path. If this is not desired, use [AnimatableBody2D] instead.
## [StaticBody2D] is useful for completely static objects like floors and walls, as well as moving surfaces like conveyor belts and circular revolving platforms (by using [member constant_linear_velocity] and [member constant_angular_velocity]).



## The body's constant angular velocity. This does not rotate the body, but affects touching bodies, as if it were rotating.
var constant_angular_velocity: float:
	get = get_constant_angular_velocity, set = set_constant_angular_velocity

## The body's constant linear velocity. This does not move the body, but affects touching bodies, as if it were moving.
var constant_linear_velocity: Vector2:
	get = get_constant_linear_velocity, set = set_constant_linear_velocity

## The physics material override for the body.
## If a material is assigned to this property, it will be used instead of any other physics material, such as an inherited one.
var physics_material_override: PhysicsMaterial:
	get = get_physics_material_override, set = set_physics_material_override




func get_constant_angular_velocity() -> float:
	return constant_angular_velocity

func set_constant_angular_velocity(value: float) -> void:
	constant_angular_velocity = value

func get_constant_linear_velocity() -> Vector2:
	return constant_linear_velocity

func set_constant_linear_velocity(value: Vector2) -> void:
	constant_linear_velocity = value

func get_physics_material_override() -> PhysicsMaterial:
	return physics_material_override

func set_physics_material_override(value: PhysicsMaterial) -> void:
	physics_material_override = value

