extends GeometryInstance3D
class_name SpriteBase3D

## 2D sprite node in 3D environment.
##
## A node that displays 2D texture information in a 3D environment. See also [Sprite3D] where many other properties are defined.


## If set, the texture's transparency and the opacity are used to make those parts of the sprite invisible.
## If set, lights in the environment affect the sprite.
## If set, texture can be seen from the back as well. If not, the texture is invisible when looking at it from behind.
## Disables the depth test, so this object is drawn on top of all others. However, objects drawn after it in the draw order may cover it.
## Label is scaled by depth so that it always appears the same size on screen.
## Represents the size of the [enum DrawFlags] enum.
## This mode performs standard alpha blending. It can display translucent areas, but transparency sorting issues may be visible when multiple transparent materials are overlapping.
## This mode only allows fully transparent or fully opaque pixels. Harsh edges will be visible unless some form of screen-space antialiasing is enabled (see [member ProjectSettings.rendering/anti_aliasing/quality/screen_space_aa]). On the bright side, this mode doesn't suffer from transparency sorting issues when multiple transparent materials are overlapping. This mode is also known as [i]alpha testing[/i] or [i]1-bit transparency[/i].
## This mode draws fully opaque pixels in the depth prepass. This is slower than [constant ALPHA_CUT_DISABLED] or [constant ALPHA_CUT_DISCARD], but it allows displaying translucent areas and smooth edges while using proper sorting.
## This mode draws cuts off all values below a spatially-deterministic threshold, the rest will remain opaque.

#enum DrawFlags
enum {
    FLAG_TRANSPARENT = 0,
    FLAG_SHADED = 1,
    FLAG_DOUBLE_SIDED = 2,
    FLAG_DISABLE_DEPTH_TEST = 3,
    FLAG_FIXED_SIZE = 4,
    FLAG_MAX = 5,
}
#enum AlphaCutMode
enum {
    ALPHA_CUT_DISABLED = 0,
    ALPHA_CUT_DISCARD = 1,
    ALPHA_CUT_OPAQUE_PREPASS = 2,
    ALPHA_CUT_HASH = 3,
}
## Threshold at which antialiasing will be applied on the alpha channel.
var alpha_antialiasing_edge: float:
	get = get_alpha_antialiasing_edge, set = set_alpha_antialiasing_edge

## The type of alpha antialiasing to apply.
var alpha_antialiasing_mode: int:
	get = get_alpha_antialiasing, set = set_alpha_antialiasing

## The alpha cutting mode to use for the sprite.
var alpha_cut: int:
	get = get_alpha_cut_mode, set = set_alpha_cut_mode

## The hashing scale for Alpha Hash. Recommended values between [code]0[/code] and [code]2[/code].
var alpha_hash_scale: float:
	get = get_alpha_hash_scale, set = set_alpha_hash_scale

## Threshold at which the alpha scissor will discard values.
var alpha_scissor_threshold: float:
	get = get_alpha_scissor_threshold, set = set_alpha_scissor_threshold

## The direction in which the front of the texture faces.
var axis: int:
	get = get_axis, set = set_axis

## The billboard mode to use for the sprite.
## [b]Note:[/b] When billboarding is enabled and the material also casts shadows, billboards will face [b]the[/b] camera in the scene when rendering shadows. In scenes with multiple cameras, the intended shadow cannot be determined and this will result in undefined behavior. See [url=https://github.com/godotengine/godot/pull/72638]GitHub Pull Request #72638[/url] for details.
var billboard: int:
	get = get_billboard_mode, set = set_billboard_mode

## If [code]true[/code], texture will be centered.
var centered: bool:
	get = is_centered, set = set_centered

## If [code]true[/code], texture can be seen from the back as well, if [code]false[/code], it is invisible when looking at it from behind.
var double_sided: bool:
	get = get_draw_flag, set = set_draw_flag

## If [code]true[/code], the texture is rendered at the same size regardless of distance. The texture's size on screen is the same as if the camera was [code]1.0[/code] units away from the texture's origin, regardless of the actual distance from the camera. The [Camera3D]'s field of view (or [member Camera3D.size] when in orthogonal/frustum mode) still affects the size the sprite is drawn at.
var fixed_size: bool:
	get = get_draw_flag, set = set_draw_flag

## If [code]true[/code], texture is flipped horizontally.
var flip_h: bool:
	get = is_flipped_h, set = set_flip_h

## If [code]true[/code], texture is flipped vertically.
var flip_v: bool:
	get = is_flipped_v, set = set_flip_v

## A color value used to [i]multiply[/i] the texture's colors. Can be used for mood-coloring or to simulate the color of ambient light.
## [b]Note:[/b] Unlike [member CanvasItem.modulate] for 2D, colors with values above [code]1.0[/code] (overbright) are not supported.
## [b]Note:[/b] If a [member GeometryInstance3D.material_override] is defined on the [SpriteBase3D], the material override must be configured to take vertex colors into account for albedo. Otherwise, the color defined in [member modulate] will be ignored. For a [BaseMaterial3D], [member BaseMaterial3D.vertex_color_use_as_albedo] must be [code]true[/code]. For a [ShaderMaterial], [code]ALBEDO *= COLOR.rgb;[/code] must be inserted in the shader's [code]fragment()[/code] function.
var modulate: Color:
	get = get_modulate, set = set_modulate

## If [code]true[/code], depth testing is disabled and the object will be drawn in render order.
var no_depth_test: bool:
	get = get_draw_flag, set = set_draw_flag

## The texture's drawing offset.
## [b]Note:[/b] When you increase [member offset].y in Sprite3D, the sprite moves upward in world space (i.e., +Y is up).
var offset: Vector2:
	get = get_offset, set = set_offset

## The size of one pixel's width on the sprite to scale it in 3D.
var pixel_size: float:
	get = get_pixel_size, set = set_pixel_size

## Sets the render priority for the sprite. Higher priority objects will be sorted in front of lower priority objects.
## [b]Note:[/b] This only applies if [member alpha_cut] is set to [constant ALPHA_CUT_DISABLED] (default value).
## [b]Note:[/b] This only applies to sorting of transparent objects. This will not impact how transparent objects are sorted relative to opaque objects. This is because opaque objects are not sorted, while transparent objects are sorted from back to front (subject to priority).
var render_priority: int:
	get = get_render_priority, set = set_render_priority

## If [code]true[/code], the [Light3D] in the [Environment] has effects on the sprite.
var shaded: bool:
	get = get_draw_flag, set = set_draw_flag

## Filter flags for the texture.
## [b]Note:[/b] Linear filtering may cause artifacts around the edges, which are especially noticeable on opaque textures. To prevent this, use textures with transparent or identical colors around the edges.
var texture_filter: int:
	get = get_texture_filter, set = set_texture_filter

## If [code]true[/code], the texture's transparency and the opacity are used to make those parts of the sprite invisible.
var transparent: bool:
	get = get_draw_flag, set = set_draw_flag



## Returns a [TriangleMesh] with the sprite's vertices following its current configuration (such as its [member axis] and [member pixel_size]).
func generate_triangle_mesh() -> TriangleMesh:
	pass;

## Returns the value of the specified flag.
func get_draw_flag(flag: int) -> bool:
	pass;

## Returns the rectangle representing this sprite.
func get_item_rect() -> Rect2:
	pass;

## If [code]true[/code], the specified flag will be enabled.
func set_draw_flag(flag: int, enabled: bool) -> void:
	pass;


func get_alpha_antialiasing_edge() -> float:
	return alpha_antialiasing_edge

func set_alpha_antialiasing_edge(value: float) -> void:
	alpha_antialiasing_edge = value

func get_alpha_antialiasing() -> int:
	return alpha_antialiasing_mode

func set_alpha_antialiasing(value: int) -> void:
	alpha_antialiasing_mode = value

func get_alpha_cut_mode() -> int:
	return alpha_cut

func set_alpha_cut_mode(value: int) -> void:
	alpha_cut = value

func get_alpha_hash_scale() -> float:
	return alpha_hash_scale

func set_alpha_hash_scale(value: float) -> void:
	alpha_hash_scale = value

func get_alpha_scissor_threshold() -> float:
	return alpha_scissor_threshold

func set_alpha_scissor_threshold(value: float) -> void:
	alpha_scissor_threshold = value

func get_axis() -> int:
	return axis

func set_axis(value: int) -> void:
	axis = value

func get_billboard_mode() -> int:
	return billboard

func set_billboard_mode(value: int) -> void:
	billboard = value

func is_centered() -> bool:
	return centered

func set_centered(value: bool) -> void:
	centered = value

func get_draw_flag() -> bool:
	return double_sided

func set_draw_flag(value: bool) -> void:
	double_sided = value

func get_draw_flag() -> bool:
	return fixed_size

func set_draw_flag(value: bool) -> void:
	fixed_size = value

func is_flipped_h() -> bool:
	return flip_h

func set_flip_h(value: bool) -> void:
	flip_h = value

func is_flipped_v() -> bool:
	return flip_v

func set_flip_v(value: bool) -> void:
	flip_v = value

func get_modulate() -> Color:
	return modulate

func set_modulate(value: Color) -> void:
	modulate = value

func get_draw_flag() -> bool:
	return no_depth_test

func set_draw_flag(value: bool) -> void:
	no_depth_test = value

func get_offset() -> Vector2:
	return offset

func set_offset(value: Vector2) -> void:
	offset = value

func get_pixel_size() -> float:
	return pixel_size

func set_pixel_size(value: float) -> void:
	pixel_size = value

func get_render_priority() -> int:
	return render_priority

func set_render_priority(value: int) -> void:
	render_priority = value

func get_draw_flag() -> bool:
	return shaded

func set_draw_flag(value: bool) -> void:
	shaded = value

func get_texture_filter() -> int:
	return texture_filter

func set_texture_filter(value: int) -> void:
	texture_filter = value

func get_draw_flag() -> bool:
	return transparent

func set_draw_flag(value: bool) -> void:
	transparent = value

