extends SkeletonModifier3D
class_name SpringBoneSimulator3D

## A [SkeletonModifier3D] to apply inertial wavering to bone chains.
##
## This [SkeletonModifier3D] can be used to wiggle hair, cloth, and tails. This modifier behaves differently from [PhysicalBoneSimulator3D] as it attempts to return the original pose after modification.
## If you setup [method set_root_bone] and [method set_end_bone], it is treated as one bone chain. Note that it does not support a branched chain like Y-shaped chains.
## When a bone chain is created, an array is generated from the bones that exist in between and listed in the joint list.
## Several properties can be applied to each joint, such as [method set_joint_stiffness], [method set_joint_drag], and [method set_joint_gravity].
## For simplicity, you can set values to all joints at the same time by using a [Curve]. If you want to specify detailed values individually, set [method set_individual_config] to [code]true[/code].
## For physical simulation, [SpringBoneSimulator3D] can have children as self-standing collisions that are not related to [PhysicsServer3D], see also [SpringBoneCollision3D].
## [b]Warning:[/b] A scaled [SpringBoneSimulator3D] will likely not behave as expected. Make sure that the parent [Skeleton3D] and its bones are not scaled.


## Enumerated value for the +X axis.
## Enumerated value for the -X axis.
## Enumerated value for the +Y axis.
## Enumerated value for the -Y axis.
## Enumerated value for the +Z axis.
## Enumerated value for the -Z axis.
## Enumerated value for the axis from a parent bone to the child bone.
## The world origin is defined as center.
## The [Node3D] specified by [method set_center_node] is defined as center.
## If [Node3D] is not found, the parent [Skeleton3D] is treated as center.
## The bone pose origin of the parent [Skeleton3D] specified by [method set_center_bone] is defined as center.
## If [Node3D] is not found, the parent [Skeleton3D] is treated as center.
## Enumerated value for the rotation of the X axis.
## Enumerated value for the rotation of the Y axis.
## Enumerated value for the rotation of the Z axis.
## Enumerated value for the unconstrained rotation.
## Enumerated value for an optional rotation axis. See also [method set_joint_rotation_axis_vector].

#enum BoneDirection
enum {
    BONE_DIRECTION_PLUS_X = 0,
    BONE_DIRECTION_MINUS_X = 1,
    BONE_DIRECTION_PLUS_Y = 2,
    BONE_DIRECTION_MINUS_Y = 3,
    BONE_DIRECTION_PLUS_Z = 4,
    BONE_DIRECTION_MINUS_Z = 5,
    BONE_DIRECTION_FROM_PARENT = 6,
}
#enum CenterFrom
enum {
    CENTER_FROM_WORLD_ORIGIN = 0,
    CENTER_FROM_NODE = 1,
    CENTER_FROM_BONE = 2,
}
#enum RotationAxis
enum {
    ROTATION_AXIS_X = 0,
    ROTATION_AXIS_Y = 1,
    ROTATION_AXIS_Z = 2,
    ROTATION_AXIS_ALL = 3,
    ROTATION_AXIS_CUSTOM = 4,
}
## The constant force that always affected bones. It is equal to the result when the parent [Skeleton3D] moves at this speed in the opposite direction.
## This is useful for effects such as wind and anti-gravity.
var external_force: Vector3:
	get = get_external_force, set = set_external_force

## The number of settings.
var setting_count: int:
	get = get_setting_count, set = set_setting_count



## Returns [code]true[/code] if all child [SpringBoneCollision3D]s are contained in the collision list at [param index] in the settings.
func are_all_child_collisions_enabled(index: int) -> bool:
	pass;

## Clears all collisions from the collision list at [param index] in the settings when [method are_all_child_collisions_enabled] is [code]false[/code].
func clear_collisions(index: int) -> void:
	pass;

## Clears all exclude collisions from the collision list at [param index] in the settings when [method are_all_child_collisions_enabled] is [code]true[/code].
func clear_exclude_collisions(index: int) -> void:
	pass;

## Clears all settings.
func clear_settings() -> void:
	pass;

## Returns the center bone index of the bone chain.
func get_center_bone(index: int) -> int:
	pass;

## Returns the center bone name of the bone chain.
func get_center_bone_name(index: int) -> String:
	pass;

## Returns what the center originates from in the bone chain.
func get_center_from(index: int) -> int:
	pass;

## Returns the center node path of the bone chain.
func get_center_node(index: int) -> NodePath:
	pass;

## Returns the collision count of the bone chain's collision list when [method are_all_child_collisions_enabled] is [code]false[/code].
func get_collision_count(index: int) -> int:
	pass;

## Returns the node path of the [SpringBoneCollision3D] at [param collision] in the bone chain's collision list when [method are_all_child_collisions_enabled] is [code]false[/code].
func get_collision_path(index: int, collision: int) -> NodePath:
	pass;

## Returns the drag force damping curve of the bone chain.
func get_drag(index: int) -> float:
	pass;

## Returns the drag force damping curve of the bone chain.
func get_drag_damping_curve(index: int) -> Curve:
	pass;

## Returns the end bone index of the bone chain.
func get_end_bone(index: int) -> int:
	pass;

## Returns the end bone's tail direction of the bone chain when [method is_end_bone_extended] is [code]true[/code].
func get_end_bone_direction(index: int) -> int:
	pass;

## Returns the end bone's tail length of the bone chain when [method is_end_bone_extended] is [code]true[/code].
func get_end_bone_length(index: int) -> float:
	pass;

## Returns the end bone name of the bone chain.
func get_end_bone_name(index: int) -> String:
	pass;

## Returns the exclude collision count of the bone chain's exclude collision list when [method are_all_child_collisions_enabled] is [code]true[/code].
func get_exclude_collision_count(index: int) -> int:
	pass;

## Returns the node path of the [SpringBoneCollision3D] at [param collision] in the bone chain's exclude collision list when [method are_all_child_collisions_enabled] is [code]true[/code].
func get_exclude_collision_path(index: int, collision: int) -> NodePath:
	pass;

## Returns the gravity amount of the bone chain.
func get_gravity(index: int) -> float:
	pass;

## Returns the gravity amount damping curve of the bone chain.
func get_gravity_damping_curve(index: int) -> Curve:
	pass;

## Returns the gravity direction of the bone chain.
func get_gravity_direction(index: int) -> Vector3:
	pass;

## Returns the bone index at [param joint] in the bone chain's joint list.
func get_joint_bone(index: int, joint: int) -> int:
	pass;

## Returns the bone name at [param joint] in the bone chain's joint list.
func get_joint_bone_name(index: int, joint: int) -> String:
	pass;

## Returns the joint count of the bone chain's joint list.
func get_joint_count(index: int) -> int:
	pass;

## Returns the drag force at [param joint] in the bone chain's joint list.
func get_joint_drag(index: int, joint: int) -> float:
	pass;

## Returns the gravity amount at [param joint] in the bone chain's joint list.
func get_joint_gravity(index: int, joint: int) -> float:
	pass;

## Returns the gravity direction at [param joint] in the bone chain's joint list.
func get_joint_gravity_direction(index: int, joint: int) -> Vector3:
	pass;

## Returns the radius at [param joint] in the bone chain's joint list.
func get_joint_radius(index: int, joint: int) -> float:
	pass;

## Returns the rotation axis at [param joint] in the bone chain's joint list.
func get_joint_rotation_axis(index: int, joint: int) -> int:
	pass;

## Returns the rotation axis vector for the specified joint in the bone chain. This vector represents the axis around which the joint can rotate. It is determined based on the rotation axis set for the joint.
## If [method get_joint_rotation_axis] is [constant ROTATION_AXIS_ALL], this method returns [code]Vector3(0, 0, 0)[/code].
func get_joint_rotation_axis_vector(index: int, joint: int) -> Vector3:
	pass;

## Returns the stiffness force at [param joint] in the bone chain's joint list.
func get_joint_stiffness(index: int, joint: int) -> float:
	pass;

## Returns the joint radius of the bone chain.
func get_radius(index: int) -> float:
	pass;

## Returns the joint radius damping curve of the bone chain.
func get_radius_damping_curve(index: int) -> Curve:
	pass;

## Returns the root bone index of the bone chain.
func get_root_bone(index: int) -> int:
	pass;

## Returns the root bone name of the bone chain.
func get_root_bone_name(index: int) -> String:
	pass;

## Returns the rotation axis of the bone chain.
func get_rotation_axis(index: int) -> int:
	pass;

## Returns the rotation axis vector of the bone chain. This vector represents the axis around which the bone chain can rotate. It is determined based on the rotation axis set for the bone chain.
## If [method get_rotation_axis] is [constant ROTATION_AXIS_ALL], this method returns [code]Vector3(0, 0, 0)[/code].
func get_rotation_axis_vector(index: int) -> Vector3:
	pass;

## Returns the stiffness force of the bone chain.
func get_stiffness(index: int) -> float:
	pass;

## Returns the stiffness force damping curve of the bone chain.
func get_stiffness_damping_curve(index: int) -> Curve:
	pass;

## Returns [code]true[/code] if the config can be edited individually for each joint.
func is_config_individual(index: int) -> bool:
	pass;

## Returns [code]true[/code] if the end bone is extended to have the tail.
func is_end_bone_extended(index: int) -> bool:
	pass;

## Resets a simulating state with respect to the current bone pose.
## It is useful to prevent the simulation result getting violent. For example, calling this immediately after a call to [method AnimationPlayer.play] without a fading, or within the previous [signal SkeletonModifier3D.modification_processed] signal if it's condition changes significantly.
func reset() -> void:
	pass;

## Sets the center bone index of the bone chain.
func set_center_bone(index: int, bone: int) -> void:
	pass;

## Sets the center bone name of the bone chain.
func set_center_bone_name(index: int, bone_name: String) -> void:
	pass;

## Sets what the center originates from in the bone chain.
## Bone movement is calculated based on the difference in relative distance between center and bone in the previous and next frames.
## For example, if the parent [Skeleton3D] is used as the center, the bones are considered to have not moved if the [Skeleton3D] moves in the world.
## In this case, only a change in the bone pose is considered to be a bone movement.
func set_center_from(index: int, center_from: int) -> void:
	pass;

## Sets the center node path of the bone chain.
func set_center_node(index: int, node_path: NodePath) -> void:
	pass;

## Sets the number of collisions in the collision list at [param index] in the settings when [method are_all_child_collisions_enabled] is [code]false[/code].
func set_collision_count(index: int, count: int) -> void:
	pass;

## Sets the node path of the [SpringBoneCollision3D] at [param collision] in the bone chain's collision list when [method are_all_child_collisions_enabled] is [code]false[/code].
func set_collision_path(index: int, collision: int, node_path: NodePath) -> void:
	pass;

## Sets the drag force of the bone chain. The greater the value, the more suppressed the wiggling.
## The value is scaled by [method set_drag_damping_curve] and cached in each joint setting in the joint list.
func set_drag(index: int, drag: float) -> void:
	pass;

## Sets the drag force damping curve of the bone chain.
func set_drag_damping_curve(index: int, curve: Curve) -> void:
	pass;

## If [param enabled] is [code]true[/code], all child [SpringBoneCollision3D]s are colliding and [method set_exclude_collision_path] is enabled as an exclusion list at [param index] in the settings.
## If [param enabled] is [code]false[/code], you need to manually register all valid collisions with [method set_collision_path].
func set_enable_all_child_collisions(index: int, enabled: bool) -> void:
	pass;

## Sets the end bone index of the bone chain.
func set_end_bone(index: int, bone: int) -> void:
	pass;

## Sets the end bone tail direction of the bone chain when [method is_end_bone_extended] is [code]true[/code].
func set_end_bone_direction(index: int, bone_direction: int) -> void:
	pass;

## Sets the end bone tail length of the bone chain when [method is_end_bone_extended] is [code]true[/code].
func set_end_bone_length(index: int, length: float) -> void:
	pass;

## Sets the end bone name of the bone chain.
## [b]Note:[/b] End bone must be the root bone or a child of the root bone. If they are the same, the tail must be extended by [method set_extend_end_bone] to jiggle the bone.
func set_end_bone_name(index: int, bone_name: String) -> void:
	pass;

## Sets the number of exclude collisions in the exclude collision list at [param index] in the settings when [method are_all_child_collisions_enabled] is [code]true[/code].
func set_exclude_collision_count(index: int, count: int) -> void:
	pass;

## Sets the node path of the [SpringBoneCollision3D] at [param collision] in the bone chain's exclude collision list when [method are_all_child_collisions_enabled] is [code]true[/code].
func set_exclude_collision_path(index: int, collision: int, node_path: NodePath) -> void:
	pass;

## If [param enabled] is [code]true[/code], the end bone is extended to have the tail.
## The extended tail config is allocated to the last element in the joint list.
## In other words, if you set [param enabled] is [code]false[/code], the config of last element in the joint list has no effect in the simulated result.
func set_extend_end_bone(index: int, enabled: bool) -> void:
	pass;

## Sets the gravity amount of the bone chain. This value is not an acceleration, but a constant velocity of movement in [method set_gravity_direction].
## If [param gravity] is not [code]0[/code], the modified pose will not return to the original pose since it is always affected by gravity.
## The value is scaled by [method set_gravity_damping_curve] and cached in each joint setting in the joint list.
func set_gravity(index: int, gravity: float) -> void:
	pass;

## Sets the gravity amount damping curve of the bone chain.
func set_gravity_damping_curve(index: int, curve: Curve) -> void:
	pass;

## Sets the gravity direction of the bone chain. This value is internally normalized and then multiplied by [method set_gravity].
## The value is cached in each joint setting in the joint list.
func set_gravity_direction(index: int, gravity_direction: Vector3) -> void:
	pass;

## If [param enabled] is [code]true[/code], the config can be edited individually for each joint.
func set_individual_config(index: int, enabled: bool) -> void:
	pass;

## Sets the drag force at [param joint] in the bone chain's joint list when [method is_config_individual] is [code]true[/code].
func set_joint_drag(index: int, joint: int, drag: float) -> void:
	pass;

## Sets the gravity amount at [param joint] in the bone chain's joint list when [method is_config_individual] is [code]true[/code].
func set_joint_gravity(index: int, joint: int, gravity: float) -> void:
	pass;

## Sets the gravity direction at [param joint] in the bone chain's joint list when [method is_config_individual] is [code]true[/code].
func set_joint_gravity_direction(index: int, joint: int, gravity_direction: Vector3) -> void:
	pass;

## Sets the joint radius at [param joint] in the bone chain's joint list when [method is_config_individual] is [code]true[/code].
func set_joint_radius(index: int, joint: int, radius: float) -> void:
	pass;

## Sets the rotation axis at [param joint] in the bone chain's joint list when [method is_config_individual] is [code]true[/code].
## The axes are based on the [method Skeleton3D.get_bone_rest]'s space, if [param axis] is [constant ROTATION_AXIS_CUSTOM], you can specify any axis.
## [b]Note:[/b] The rotation axis and the forward vector shouldn't be colinear to avoid unintended rotation since [SpringBoneSimulator3D] does not factor in twisting forces.
func set_joint_rotation_axis(index: int, joint: int, axis: int) -> void:
	pass;

## Sets the rotation axis vector for the specified joint in the bone chain.
## This vector is normalized by an internal process and represents the axis around which the bone chain can rotate.
## If the vector length is [code]0[/code], it is considered synonymous with [constant ROTATION_AXIS_ALL].
func set_joint_rotation_axis_vector(index: int, joint: int, vector: Vector3) -> void:
	pass;

## Sets the stiffness force at [param joint] in the bone chain's joint list when [method is_config_individual] is [code]true[/code].
func set_joint_stiffness(index: int, joint: int, stiffness: float) -> void:
	pass;

## Sets the joint radius of the bone chain. It is used to move and slide with the [SpringBoneCollision3D] in the collision list.
## The value is scaled by [method set_radius_damping_curve] and cached in each joint setting in the joint list.
func set_radius(index: int, radius: float) -> void:
	pass;

## Sets the joint radius damping curve of the bone chain.
func set_radius_damping_curve(index: int, curve: Curve) -> void:
	pass;

## Sets the root bone index of the bone chain.
func set_root_bone(index: int, bone: int) -> void:
	pass;

## Sets the root bone name of the bone chain.
func set_root_bone_name(index: int, bone_name: String) -> void:
	pass;

## Sets the rotation axis of the bone chain. If set to a specific axis, it acts like a hinge joint. The value is cached in each joint setting in the joint list.
## The axes are based on the [method Skeleton3D.get_bone_rest]'s space, if [param axis] is [constant ROTATION_AXIS_CUSTOM], you can specify any axis.
## [b]Note:[/b] The rotation axis vector and the forward vector shouldn't be colinear to avoid unintended rotation since [SpringBoneSimulator3D] does not factor in twisting forces.
func set_rotation_axis(index: int, axis: int) -> void:
	pass;

## Sets the rotation axis vector of the bone chain. The value is cached in each joint setting in the joint list.
## This vector is normalized by an internal process and represents the axis around which the bone chain can rotate.
## If the vector length is [code]0[/code], it is considered synonymous with [constant ROTATION_AXIS_ALL].
func set_rotation_axis_vector(index: int, vector: Vector3) -> void:
	pass;

## Sets the stiffness force of the bone chain. The greater the value, the faster it recovers to its initial pose.
## If [param stiffness] is [code]0[/code], the modified pose will not return to the original pose.
## The value is scaled by [method set_stiffness_damping_curve] and cached in each joint setting in the joint list.
func set_stiffness(index: int, stiffness: float) -> void:
	pass;

## Sets the stiffness force damping curve of the bone chain.
func set_stiffness_damping_curve(index: int, curve: Curve) -> void:
	pass;


func get_external_force() -> Vector3:
	return external_force

func set_external_force(value: Vector3) -> void:
	external_force = value

func get_setting_count() -> int:
	return setting_count

func set_setting_count(value: int) -> void:
	setting_count = value

