extends SpringBoneCollision3D
class_name SpringBoneCollisionCapsule3D

## A capsule shape collision that interacts with [SpringBoneSimulator3D].
##
## A capsule shape collision that interacts with [SpringBoneSimulator3D].



## The capsule's full height, including the hemispheres.
var height: float:
	get = get_height, set = set_height

## If [code]true[/code], the collision acts to trap the joint within the collision.
var inside: bool:
	get = is_inside, set = set_inside

## The capsule's height, excluding the hemispheres. This is the height of the central cylindrical part in the middle of the capsule, and is the distance between the centers of the two hemispheres. This is a wrapper for [member height].
var mid_height: float:
	get = get_mid_height, set = set_mid_height

## The capsule's radius.
var radius: float:
	get = get_radius, set = set_radius




func get_height() -> float:
	return height

func set_height(value: float) -> void:
	height = value

func is_inside() -> bool:
	return inside

func set_inside(value: bool) -> void:
	inside = value

func get_mid_height() -> float:
	return mid_height

func set_mid_height(value: float) -> void:
	mid_height = value

func get_radius() -> float:
	return radius

func set_radius(value: float) -> void:
	radius = value

