extends Container
class_name SplitContainer

## A container that splits two child controls horizontally or vertically and provides a grabber for adjusting the split ratio.
##
## A container that accepts only two child controls, then arranges them horizontally or vertically and creates a divisor between them. The divisor can be dragged around to change the size relation between the child controls.
##
## @tutorial(Using Containers): https://docs.godotengine.org/en/stable/tutorials/ui/gui_containers.html


## Emitted when the user ends dragging.
signal drag_ended
## Emitted when the user starts dragging.
signal drag_started
## Emitted when the dragger is dragged by user.
signal dragged(offset: int)
## The split dragger icon is always visible when [theme_item autohide] is [code]false[/code], otherwise visible only when the cursor hovers it.
## The size of the grabber icon determines the minimum [theme_item separation].
## The dragger icon is automatically hidden if the length of the grabber icon is longer than the split bar.
## The split dragger icon is never visible regardless of the value of [theme_item autohide].
## The size of the grabber icon determines the minimum [theme_item separation].
## The split dragger icon is not visible, and the split bar is collapsed to zero thickness.

#enum DraggerVisibility
enum {
    DRAGGER_VISIBLE = 0,
    DRAGGER_HIDDEN = 1,
    DRAGGER_HIDDEN_COLLAPSED = 2,
}
## If [code]true[/code], the dragger will be disabled and the children will be sized as if the [member split_offset] was [code]0[/code].
var collapsed: bool:
	get = is_collapsed, set = set_collapsed

## Highlights the drag area [Rect2] so you can see where it is during development. The drag area is gold if [member dragging_enabled] is [code]true[/code], and red if [code]false[/code].
var drag_area_highlight_in_editor: bool:
	get = is_drag_area_highlight_in_editor_enabled, set = set_drag_area_highlight_in_editor

## Reduces the size of the drag area and split bar [theme_item split_bar_background] at the beginning of the container.
var drag_area_margin_begin: int:
	get = get_drag_area_margin_begin, set = set_drag_area_margin_begin

## Reduces the size of the drag area and split bar [theme_item split_bar_background] at the end of the container.
var drag_area_margin_end: int:
	get = get_drag_area_margin_end, set = set_drag_area_margin_end

## Shifts the drag area in the axis of the container to prevent the drag area from overlapping the [ScrollBar] or other selectable [Control] of a child node.
var drag_area_offset: int:
	get = get_drag_area_offset, set = set_drag_area_offset

## Determines the dragger's visibility. This property does not determine whether dragging is enabled or not. Use [member dragging_enabled] for that.
var dragger_visibility: int:
	get = get_dragger_visibility, set = set_dragger_visibility

## Enables or disables split dragging.
var dragging_enabled: bool:
	get = is_dragging_enabled, set = set_dragging_enabled

## The initial offset of the splitting between the two [Control]s, with [code]0[/code] being at the end of the first [Control].
var split_offset: int:
	get = get_split_offset, set = set_split_offset

## If [code]true[/code], a touch-friendly drag handle will be enabled for better usability on smaller screens. Unlike the standard grabber, this drag handle overlaps the [SplitContainer]'s children and does not affect their minimum separation. The standard grabber will no longer be drawn when this option is enabled.
var touch_dragger_enabled: bool:
	get = is_touch_dragger_enabled, set = set_touch_dragger_enabled

## If [code]true[/code], the [SplitContainer] will arrange its children vertically, rather than horizontally.
## Can't be changed when using [HSplitContainer] and [VSplitContainer].
var vertical: bool:
	get = is_vertical, set = set_vertical



## Clamps the [member split_offset] value to not go outside the currently possible minimal and maximum values.
func clamp_split_offset() -> void:
	pass;

## Returns the drag area [Control]. For example, you can move a pre-configured button into the drag area [Control] so that it rides along with the split bar. Try setting the [Button] anchors to [code]center[/code] prior to the [code]reparent()[/code] call.
## [codeblock]
## $BarnacleButton.reparent($SplitContainer.get_drag_area_control())
## [/codeblock]
## [b]Note:[/b] The drag area [Control] is drawn over the [SplitContainer]'s children, so [CanvasItem] draw objects called from the [Control] and children added to the [Control] will also appear over the [SplitContainer]'s children. Try setting [member Control.mouse_filter] of custom children to [constant Control.MOUSE_FILTER_IGNORE] to prevent blocking the mouse from dragging if desired.
## [b]Warning:[/b] This is a required internal node, removing and freeing it may cause a crash.
func get_drag_area_control() -> Control:
	pass;


func is_collapsed() -> bool:
	return collapsed

func set_collapsed(value: bool) -> void:
	collapsed = value

func is_drag_area_highlight_in_editor_enabled() -> bool:
	return drag_area_highlight_in_editor

func set_drag_area_highlight_in_editor(value: bool) -> void:
	drag_area_highlight_in_editor = value

func get_drag_area_margin_begin() -> int:
	return drag_area_margin_begin

func set_drag_area_margin_begin(value: int) -> void:
	drag_area_margin_begin = value

func get_drag_area_margin_end() -> int:
	return drag_area_margin_end

func set_drag_area_margin_end(value: int) -> void:
	drag_area_margin_end = value

func get_drag_area_offset() -> int:
	return drag_area_offset

func set_drag_area_offset(value: int) -> void:
	drag_area_offset = value

func get_dragger_visibility() -> int:
	return dragger_visibility

func set_dragger_visibility(value: int) -> void:
	dragger_visibility = value

func is_dragging_enabled() -> bool:
	return dragging_enabled

func set_dragging_enabled(value: bool) -> void:
	dragging_enabled = value

func get_split_offset() -> int:
	return split_offset

func set_split_offset(value: int) -> void:
	split_offset = value

func is_touch_dragger_enabled() -> bool:
	return touch_dragger_enabled

func set_touch_dragger_enabled(value: bool) -> void:
	touch_dragger_enabled = value

func is_vertical() -> bool:
	return vertical

func set_vertical(value: bool) -> void:
	vertical = value

