extends Range
class_name ScrollBar

## Abstract base class for scrollbars.
##
## Abstract base class for scrollbars, typically used to navigate through content that extends beyond the visible area of a control. Scrollbars are [Range]-based controls.


## Emitted when the scrollbar is being scrolled.
signal scrolling

## Overrides the step used when clicking increment and decrement buttons or when using arrow keys when the [ScrollBar] is focused.
var custom_step: float:
	get = get_custom_step, set = set_custom_step

var focus_mode: int:
	get = get_focus_mode, set = set_focus_mode

var step: float:
	get = get_step, set = set_step




func get_custom_step() -> float:
	return custom_step

func set_custom_step(value: float) -> void:
	custom_step = value

func get_focus_mode() -> int:
	return focus_mode

func set_focus_mode(value: int) -> void:
	focus_mode = value

func get_step() -> float:
	return step

func set_step(value: float) -> void:
	step = value

