extends RefCounted
class_name ScriptBacktrace

## A captured backtrace of a specific script language.
##
## [ScriptBacktrace] holds an already captured backtrace of a specific script language, such as GDScript or C#, which are captured using [method Engine.capture_script_backtraces].
## See [member ProjectSettings.debug/settings/gdscript/always_track_call_stacks] and [member ProjectSettings.debug/settings/gdscript/always_track_local_variables] for ways of controlling the contents of this class.





## Converts the backtrace to a [String], where the entire string will be indented by [param indent_all] number of spaces, and the individual stack frames will be additionally indented by [param indent_frames] number of spaces.
## [b]Note:[/b] Calling [method Object.to_string] on a [ScriptBacktrace] will produce the same output as calling [method format] with all parameters left at their default values.
func format(indent_all: int = 0, indent_frames: int = 4) -> String:
	pass;

## Returns the number of stack frames in the backtrace.
func get_frame_count() -> int:
	pass;

## Returns the file name of the call site represented by the stack frame at the specified index.
func get_frame_file(index: int) -> String:
	pass;

## Returns the name of the function called at the stack frame at the specified index.
func get_frame_function(index: int) -> String:
	pass;

## Returns the line number of the call site represented by the stack frame at the specified index.
func get_frame_line(index: int) -> int:
	pass;

## Returns the number of global variables (e.g. autoload singletons) in the backtrace.
## [b]Note:[/b] This will be non-zero only if the [code]include_variables[/code] parameter was [code]true[/code] when capturing the backtrace with [method Engine.capture_script_backtraces].
func get_global_variable_count() -> int:
	pass;

## Returns the name of the global variable at the specified index.
func get_global_variable_name(variable_index: int) -> String:
	pass;

## Returns the value of the global variable at the specified index.
## [b]Warning:[/b] With GDScript backtraces, the returned [Variant] will be the variable's actual value, including any object references. This means that storing the returned [Variant] will prevent any such object from being deallocated, so it's generally recommended not to do so.
func get_global_variable_value(variable_index: int) -> Variant:
	pass;

## Returns the name of the script language that this backtrace was captured from.
func get_language_name() -> String:
	pass;

## Returns the number of local variables in the stack frame at the specified index.
## [b]Note:[/b] This will be non-zero only if the [code]include_variables[/code] parameter was [code]true[/code] when capturing the backtrace with [method Engine.capture_script_backtraces].
func get_local_variable_count(frame_index: int) -> int:
	pass;

## Returns the name of the local variable at the specified [param variable_index] in the stack frame at the specified [param frame_index].
func get_local_variable_name(frame_index: int, variable_index: int) -> String:
	pass;

## Returns the value of the local variable at the specified [param variable_index] in the stack frame at the specified [param frame_index].
## [b]Warning:[/b] With GDScript backtraces, the returned [Variant] will be the variable's actual value, including any object references. This means that storing the returned [Variant] will prevent any such object from being deallocated, so it's generally recommended not to do so.
func get_local_variable_value(frame_index: int, variable_index: int) -> Variant:
	pass;

## Returns the number of member variables in the stack frame at the specified index.
## [b]Note:[/b] This will be non-zero only if the [code]include_variables[/code] parameter was [code]true[/code] when capturing the backtrace with [method Engine.capture_script_backtraces].
func get_member_variable_count(frame_index: int) -> int:
	pass;

## Returns the name of the member variable at the specified [param variable_index] in the stack frame at the specified [param frame_index].
func get_member_variable_name(frame_index: int, variable_index: int) -> String:
	pass;

## Returns the value of the member variable at the specified [param variable_index] in the stack frame at the specified [param frame_index].
## [b]Warning:[/b] With GDScript backtraces, the returned [Variant] will be the variable's actual value, including any object references. This means that storing the returned [Variant] will prevent any such object from being deallocated, so it's generally recommended not to do so.
func get_member_variable_value(frame_index: int, variable_index: int) -> Variant:
	pass;

## Returns [code]true[/code] if the backtrace has no stack frames.
func is_empty() -> bool:
	pass;


