extends RefCounted
class_name SceneState

## Provides access to a scene file's information.
##
## Maintains a list of resources, nodes, exported and overridden properties, and built-in scripts associated with a scene. They cannot be modified from a [SceneState], only accessed. Useful for peeking into what a [PackedScene] contains without instantiating it.
## This class cannot be instantiated directly, it is retrieved for a given scene as the result of [method PackedScene.get_state].


## If passed to [method PackedScene.instantiate], blocks edits to the scene state.
## If passed to [method PackedScene.instantiate], provides inherited scene resources to the local scene.
## [b]Note:[/b] Only available in editor builds.
## If passed to [method PackedScene.instantiate], provides local scene resources to the local scene. Only the main scene should receive the main edit state.
## [b]Note:[/b] Only available in editor builds.
## If passed to [method PackedScene.instantiate], it's similar to [constant GEN_EDIT_STATE_MAIN], but for the case where the scene is being instantiated to be the base of another one.
## [b]Note:[/b] Only available in editor builds.

#enum GenEditState
enum {
    GEN_EDIT_STATE_DISABLED = 0,
    GEN_EDIT_STATE_INSTANCE = 1,
    GEN_EDIT_STATE_MAIN = 2,
    GEN_EDIT_STATE_MAIN_INHERITED = 3,
}


## Returns the [SceneState] of the scene that this scene inherits from, or [code]null[/code] if it doesn't inherit from any scene.
func get_base_scene_state() -> SceneState:
	pass;

## Returns the list of bound parameters for the signal at [param idx].
func get_connection_binds(idx: int) -> Array:
	pass;

## Returns the number of signal connections in the scene.
## The [code]idx[/code] argument used to query connection metadata in other [code]get_connection_*[/code] methods in the interval [code][0, get_connection_count() - 1][/code].
func get_connection_count() -> int:
	pass;

## Returns the connection flags for the signal at [param idx]. See [enum Object.ConnectFlags] constants.
func get_connection_flags(idx: int) -> int:
	pass;

## Returns the method connected to the signal at [param idx].
func get_connection_method(idx: int) -> StringName:
	pass;

## Returns the name of the signal at [param idx].
func get_connection_signal(idx: int) -> StringName:
	pass;

## Returns the path to the node that owns the signal at [param idx], relative to the root node.
func get_connection_source(idx: int) -> NodePath:
	pass;

## Returns the path to the node that owns the method connected to the signal at [param idx], relative to the root node.
func get_connection_target(idx: int) -> NodePath:
	pass;

## Returns the number of unbound parameters for the signal at [param idx].
func get_connection_unbinds(idx: int) -> int:
	pass;

## Returns the number of nodes in the scene.
## The [code]idx[/code] argument used to query node data in other [code]get_node_*[/code] methods in the interval [code][0, get_node_count() - 1][/code].
func get_node_count() -> int:
	pass;

## Returns the list of group names associated with the node at [param idx].
func get_node_groups(idx: int) -> PackedStringArray:
	pass;

## Returns the node's index, which is its position relative to its siblings. This is only relevant and saved in scenes for cases where new nodes are added to an instantiated or inherited scene among siblings from the base scene. Despite the name, this index is not related to the [param idx] argument used here and in other methods.
func get_node_index(idx: int) -> int:
	pass;

## Returns a [PackedScene] for the node at [param idx] (i.e. the whole branch starting at this node, with its child nodes and resources), or [code]null[/code] if the node is not an instance.
func get_node_instance(idx: int) -> PackedScene:
	pass;

## Returns the path to the represented scene file if the node at [param idx] is an [InstancePlaceholder].
func get_node_instance_placeholder(idx: int) -> String:
	pass;

## Returns the name of the node at [param idx].
func get_node_name(idx: int) -> StringName:
	pass;

## Returns the path to the owner of the node at [param idx], relative to the root node.
func get_node_owner_path(idx: int) -> NodePath:
	pass;

## Returns the path to the node at [param idx].
## If [param for_parent] is [code]true[/code], returns the path of the [param idx] node's parent instead.
func get_node_path(idx: int, for_parent: bool = false) -> NodePath:
	pass;

## Returns the number of exported or overridden properties for the node at [param idx].
## The [code]prop_idx[/code] argument used to query node property data in other [code]get_node_property_*[/code] methods in the interval [code][0, get_node_property_count() - 1][/code].
func get_node_property_count(idx: int) -> int:
	pass;

## Returns the name of the property at [param prop_idx] for the node at [param idx].
func get_node_property_name(idx: int, prop_idx: int) -> StringName:
	pass;

## Returns the value of the property at [param prop_idx] for the node at [param idx].
func get_node_property_value(idx: int, prop_idx: int) -> Variant:
	pass;

## Returns the type of the node at [param idx].
func get_node_type(idx: int) -> StringName:
	pass;

## Returns the resource path to the represented [PackedScene].
func get_path() -> String:
	pass;

## Returns [code]true[/code] if the node at [param idx] is an [InstancePlaceholder].
func is_node_instance_placeholder(idx: int) -> bool:
	pass;


