extends Texture2D
class_name SVGTexture

## A scalable [Texture2D] based on an SVG image.
##
## A scalable [Texture2D] based on an SVG image. [SVGTexture]s are automatically re-rasterized to match font oversampling.



## SVG texture scale. [code]1.0[/code] is the original SVG size. Higher values result in a larger image.
var base_scale: float:
	get = get_base_scale, set = set_base_scale

## If set, remaps SVG texture colors according to [Color]-[Color] map.
var color_map: Dictionary:
	get = get_color_map, set = set_color_map

var resource_local_to_scene: bool:
	get = is_local_to_scene, set = set_local_to_scene

## Overrides texture saturation.
var saturation: float:
	get = get_saturation, set = set_saturation



## Creates a new [SVGTexture] and initializes it by allocating and setting the SVG data from string.
static func create_from_string(source: String, scale: float = 1.0, saturation: float = 1.0, color_map: Dictionary = {}) -> SVGTexture:
	pass;

## Returns SVG source code.
func get_source() -> String:
	pass;

## Resizes the texture to the specified dimensions.
func set_size_override(size: Vector2i) -> void:
	pass;

## Sets SVG source code.
func set_source(source: String) -> void:
	pass;


func get_base_scale() -> float:
	return base_scale

func set_base_scale(value: float) -> void:
	base_scale = value

func get_color_map() -> Dictionary:
	return color_map

func set_color_map(value: Dictionary) -> void:
	color_map = value

func is_local_to_scene() -> bool:
	return resource_local_to_scene

func set_local_to_scene(value: bool) -> void:
	resource_local_to_scene = value

func get_saturation() -> float:
	return saturation

func set_saturation(value: float) -> void:
	saturation = value

