extends ResourceImporter
class_name ResourceImporterSVG

## Imports a SVG file as a scalable texture for use in 2D or 3D rendering.
##
## This importer imports [SVGTexture] resources. See also [ResourceImporterTexture] and [ResourceImporterImage].



## SVG texture scale. [code]1.0[/code] is the original SVG size. Higher values result in a larger image.
var base_scale: float

## If set, remaps SVG texture colors according to [Color]-[Color] map.
var color_map: Dictionary

## If [code]true[/code], uses lossless compression for the SVG source.
var compress: bool

## Overrides texture saturation.
var saturation: float




