extends RefCounted
class_name ResourceImporter

## Base class for resource importers.
##
## This is the base class for Godot's resource importers. To implement your own resource importers using editor plugins, see [EditorImportPlugin].
##
## @tutorial(Import plugins): https://docs.godotengine.org/en/stable/tutorials/plugins/editor/import_plugins.html


## The default import order.
## The import order for scenes, which ensures scenes are imported [i]after[/i] all other core resources such as textures. Custom importers should generally have an import order lower than [code]100[/code] to avoid issues when importing scenes that rely on custom resources.

#enum ImportOrder
enum {
    IMPORT_ORDER_DEFAULT = 0,
    IMPORT_ORDER_SCENE = 100,
}


## Called when the engine compilation profile editor wants to check what build options an imported resource needs. For example, [ResourceImporterDynamicFont] has a property called [member ResourceImporterDynamicFont.multichannel_signed_distance_field], that depends on the engine to be build with the "msdfgen" module. If that resource happened to be a custom one, it would be handled like this:
## [codeblock]
## func _get_build_dependencies(path):
## var resource = load(path)
## var dependencies = PackedStringArray()
## if resource.multichannel_signed_distance_field:
## dependencies.push_back("module_msdfgen_enabled")
## return dependencies
## [/codeblock]
func _get_build_dependencies(path: String) -> PackedStringArray:
	pass;


