extends RenderSceneBuffers
class_name RenderSceneBuffersRD

## Render scene buffer implementation for the RenderingDevice based renderers.
##
## This object manages all 3D rendering buffers for the rendering device based renderers. An instance of this object is created for every viewport that has 3D rendering enabled.
## All buffers are organized in [b]contexts[/b]. The default context is called [b]render_buffers[/b] and can contain amongst others the color buffer, depth buffer, velocity buffers, VRS density map and MSAA variants of these buffers.
## Buffers are only guaranteed to exist during rendering of the viewport.
## [b]Note:[/b] This is an internal rendering server object, do not instantiate this from script.





## Frees all buffers related to this context.
func clear_context(context: StringName) -> void:
	pass;

## Create a new texture with the given definition and cache this under the given name. Will return the existing texture if it already exists.
func create_texture(context: StringName, name: StringName, data_format: int, usage_bits: int, texture_samples: int, size: Vector2i, layers: int, mipmaps: int, unique: bool, discardable: bool) -> RID:
	pass;

## Create a new texture using the given format and view and cache this under the given name. Will return the existing texture if it already exists.
func create_texture_from_format(context: StringName, name: StringName, format: RDTextureFormat, view: RDTextureView, unique: bool) -> RID:
	pass;

## Create a new texture view for an existing texture and cache this under the given [param view_name]. Will return the existing texture view if it already exists. Will error if the source texture doesn't exist.
func create_texture_view(context: StringName, name: StringName, view_name: StringName, view: RDTextureView) -> RID:
	pass;

## Returns the specified layer from the color texture we are rendering 3D content to.
## If [param msaa] is [code]true[/code] and MSAA is enabled, this returns the MSAA variant of the buffer.
func get_color_layer(layer: int, msaa: bool = false) -> RID:
	pass;

## Returns the color texture we are rendering 3D content to. If multiview is used this will be a texture array with all views.
## If [param msaa] is [code]true[/code] and MSAA is enabled, this returns the MSAA variant of the buffer.
func get_color_texture(msaa: bool = false) -> RID:
	pass;

## Returns the specified layer from the depth texture we are rendering 3D content to.
## If [param msaa] is [code]true[/code] and MSAA is enabled, this returns the MSAA variant of the buffer.
func get_depth_layer(layer: int, msaa: bool = false) -> RID:
	pass;

## Returns the depth texture we are rendering 3D content to. If multiview is used this will be a texture array with all views.
## If [param msaa] is [code]true[/code] and MSAA is enabled, this returns the MSAA variant of the buffer.
func get_depth_texture(msaa: bool = false) -> RID:
	pass;

## Returns the FSR sharpness value used while rendering the 3D content (if [method get_scaling_3d_mode] is an FSR mode).
func get_fsr_sharpness() -> float:
	pass;

## Returns the internal size of the render buffer (size before upscaling) with which textures are created by default.
func get_internal_size() -> Vector2i:
	pass;

## Returns the applied 3D MSAA mode for this viewport.
func get_msaa_3d() -> int:
	pass;

## Returns the render target associated with this buffers object.
func get_render_target() -> RID:
	pass;

## Returns the scaling mode used for upscaling.
func get_scaling_3d_mode() -> int:
	pass;

## Returns the screen-space antialiasing method applied.
func get_screen_space_aa() -> int:
	pass;

## Returns the target size of the render buffer (size after upscaling).
func get_target_size() -> Vector2i:
	pass;

## Returns a cached texture with this name.
func get_texture(context: StringName, name: StringName) -> RID:
	pass;

## Returns the texture format information with which a cached texture was created.
func get_texture_format(context: StringName, name: StringName) -> RDTextureFormat:
	pass;

## Returns the number of MSAA samples used.
func get_texture_samples() -> int:
	pass;

## Returns a specific slice (layer or mipmap) for a cached texture.
func get_texture_slice(context: StringName, name: StringName, layer: int, mipmap: int, layers: int, mipmaps: int) -> RID:
	pass;

## Returns the texture size of a given slice of a cached texture.
func get_texture_slice_size(context: StringName, name: StringName, mipmap: int) -> Vector2i:
	pass;

## Returns a specific view of a slice (layer or mipmap) for a cached texture.
func get_texture_slice_view(context: StringName, name: StringName, layer: int, mipmap: int, layers: int, mipmaps: int, view: RDTextureView) -> RID:
	pass;

## Returns [code]true[/code] if debanding is enabled.
func get_use_debanding() -> bool:
	pass;

## Returns [code]true[/code] if TAA is enabled.
func get_use_taa() -> bool:
	pass;

## Returns the specified layer from the velocity texture we are rendering 3D content to.
func get_velocity_layer(layer: int, msaa: bool = false) -> RID:
	pass;

## Returns the velocity texture we are rendering 3D content to. If multiview is used this will be a texture array with all views.
## If [param msaa] is [b]true[/b] and MSAA is enabled, this returns the MSAA variant of the buffer.
func get_velocity_texture(msaa: bool = false) -> RID:
	pass;

## Returns the view count for the associated viewport.
func get_view_count() -> int:
	pass;

## Returns [code]true[/code] if a cached texture exists for this name.
func has_texture(context: StringName, name: StringName) -> bool:
	pass;


