extends RefCounted
class_name RDVertexAttribute

## Vertex attribute (used by [RenderingDevice]).
##
## This object is used by [RenderingDevice].



## The way that this attribute's data is interpreted when sent to a shader.
var format: int:
	get = get_format, set = set_format

## The rate at which this attribute is pulled from its vertex buffer.
var frequency: int:
	get = get_frequency, set = set_frequency

## The location in the shader that this attribute is bound to.
var location: int:
	get = get_location, set = set_location

## The number of bytes between the start of the vertex buffer and the first instance of this attribute.
var offset: int:
	get = get_offset, set = set_offset

## The number of bytes between the starts of consecutive instances of this attribute.
var stride: int:
	get = get_stride, set = set_stride




func get_format() -> int:
	return format

func set_format(value: int) -> void:
	format = value

func get_frequency() -> int:
	return frequency

func set_frequency(value: int) -> void:
	frequency = value

func get_location() -> int:
	return location

func set_location(value: int) -> void:
	location = value

func get_offset() -> int:
	return offset

func set_offset(value: int) -> void:
	offset = value

func get_stride() -> int:
	return stride

func set_stride(value: int) -> void:
	stride = value

