extends Range
class_name ProgressBar

## A control used for visual representation of a percentage.
##
## A control used for visual representation of a percentage. Shows the fill percentage in the center. Can also be used to show indeterminate progress. For more fill modes, use [TextureProgressBar] instead.


## The progress bar fills from begin to end horizontally, according to the language direction. If [method Control.is_layout_rtl] returns [code]false[/code], it fills from left to right, and if it returns [code]true[/code], it fills from right to left.
## The progress bar fills from end to begin horizontally, according to the language direction. If [method Control.is_layout_rtl] returns [code]false[/code], it fills from right to left, and if it returns [code]true[/code], it fills from left to right.
## The progress fills from top to bottom.
## The progress fills from bottom to top.

#enum FillMode
enum {
    FILL_BEGIN_TO_END = 0,
    FILL_END_TO_BEGIN = 1,
    FILL_TOP_TO_BOTTOM = 2,
    FILL_BOTTOM_TO_TOP = 3,
}
## If [code]false[/code], the [member indeterminate] animation will be paused in the editor.
var editor_preview_indeterminate: bool:
	get = is_editor_preview_indeterminate_enabled, set = set_editor_preview_indeterminate

## The fill direction. See [enum FillMode] for possible values.
var fill_mode: int:
	get = get_fill_mode, set = set_fill_mode

## When set to [code]true[/code], the progress bar indicates that something is happening with an animation, but does not show the fill percentage or value.
var indeterminate: bool:
	get = is_indeterminate, set = set_indeterminate

## If [code]true[/code], the fill percentage is displayed on the bar.
var show_percentage: bool:
	get = is_percentage_shown, set = set_show_percentage




func is_editor_preview_indeterminate_enabled() -> bool:
	return editor_preview_indeterminate

func set_editor_preview_indeterminate(value: bool) -> void:
	editor_preview_indeterminate = value

func get_fill_mode() -> int:
	return fill_mode

func set_fill_mode(value: int) -> void:
	fill_mode = value

func is_indeterminate() -> bool:
	return indeterminate

func set_indeterminate(value: bool) -> void:
	indeterminate = value

func is_percentage_shown() -> bool:
	return show_percentage

func set_show_percentage(value: bool) -> void:
	show_percentage = value

