extends Node3D
class_name Path3D

## Contains a [Curve3D] path for [PathFollow3D] nodes to follow.
##
## Can have [PathFollow3D] child nodes moving along the [Curve3D]. See [PathFollow3D] for more information on the usage.
## Note that the path is considered as relative to the moved nodes (children of [PathFollow3D]). As such, the curve should usually start with a zero vector [code](0, 0, 0)[/code].


## Emitted when the [member curve] changes.
signal curve_changed
## Emitted when the [member debug_custom_color] changes.
signal debug_color_changed

## A [Curve3D] describing the path.
var curve: Curve3D:
	get = get_curve, set = set_curve

## The custom color to use to draw the shape in the editor.
## If set to [code]Color(0.0, 0.0, 0.0)[/code] (by default), the color set in EditorSettings is used.
var debug_custom_color: Color:
	get = get_debug_custom_color, set = set_debug_custom_color




func get_curve() -> Curve3D:
	return curve

func set_curve(value: Curve3D) -> void:
	curve = value

func get_debug_custom_color() -> Color:
	return debug_custom_color

func set_debug_custom_color(value: Color) -> void:
	debug_custom_color = value

