extends Node2D
class_name ParallaxLayer

## A parallax scrolling layer to be used with [ParallaxBackground].
##
## A ParallaxLayer must be the child of a [ParallaxBackground] node. Each ParallaxLayer can be set to move at different speeds relative to the camera movement or the [member ParallaxBackground.scroll_offset] value.
## This node's children will be affected by its scroll offset.
## [b]Note:[/b] Any changes to this node's position and scale made after it enters the scene will be ignored.



## The interval, in pixels, at which the [ParallaxLayer] is drawn repeatedly. Useful for creating an infinitely scrolling background. If an axis is set to [code]0[/code], the [ParallaxLayer] will be drawn only once along that direction.
## [b]Note:[/b] If you want the repetition to pixel-perfect match a [Texture2D] displayed by a child node, you should account for any scale applied to the texture when defining this interval. For example, if you use a child [Sprite2D] scaled to [code]0.5[/code] to display a 600x600 texture, and want this sprite to be repeated continuously horizontally, you should set the mirroring to [code]Vector2(300, 0)[/code].
## [b]Note:[/b] If the length of the viewport axis is bigger than twice the repeated axis size, it will not repeat infinitely, as the parallax layer only draws 2 instances of the layer at any given time. The visibility window is calculated from the parent [ParallaxBackground]'s position, not the layer's own position. So, if you use mirroring, [b]do not[/b] change the [ParallaxLayer] position relative to its parent. Instead, if you need to adjust the background's position, set the [member CanvasLayer.offset] property in the parent [ParallaxBackground].
## [b]Note:[/b] Despite the name, the layer will not be mirrored, it will only be repeated.
var motion_mirroring: Vector2:
	get = get_mirroring, set = set_mirroring

## The ParallaxLayer's offset relative to the parent ParallaxBackground's [member ParallaxBackground.scroll_offset].
var motion_offset: Vector2:
	get = get_motion_offset, set = set_motion_offset

## Multiplies the ParallaxLayer's motion. If an axis is set to [code]0[/code], it will not scroll.
var motion_scale: Vector2:
	get = get_motion_scale, set = set_motion_scale

var physics_interpolation_mode: int:
	get = get_physics_interpolation_mode, set = set_physics_interpolation_mode




func get_mirroring() -> Vector2:
	return motion_mirroring

func set_mirroring(value: Vector2) -> void:
	motion_mirroring = value

func get_motion_offset() -> Vector2:
	return motion_offset

func set_motion_offset(value: Vector2) -> void:
	motion_offset = value

func get_motion_scale() -> Vector2:
	return motion_scale

func set_motion_scale(value: Vector2) -> void:
	motion_scale = value

func get_physics_interpolation_mode() -> int:
	return physics_interpolation_mode

func set_physics_interpolation_mode(value: int) -> void:
	physics_interpolation_mode = value

