extends Node2D
class_name Parallax2D

## A node used to create a parallax scrolling background.
##
## A [Parallax2D] is used to create a parallax effect. It can move at a different speed relative to the camera movement using [member scroll_scale]. This creates an illusion of depth in a 2D game. If manual scrolling is desired, the [Camera2D] position can be ignored with [member ignore_camera_scroll].
## [b]Note:[/b] Any changes to this node's position made after it enters the scene tree will be overridden if [member ignore_camera_scroll] is [code]false[/code] or [member screen_offset] is modified.
##
## @tutorial(2D Parallax): https://docs.godotengine.org/en/stable/tutorials/2d/2d_parallax.html



## Velocity at which the offset scrolls automatically, in pixels per second.
var autoscroll: Vector2:
	get = get_autoscroll, set = set_autoscroll

## If [code]true[/code], this [Parallax2D] is offset by the current camera's position. If the [Parallax2D] is in a [CanvasLayer] separate from the current camera, it may be desired to match the value with [member CanvasLayer.follow_viewport_enabled].
var follow_viewport: bool:
	get = get_follow_viewport, set = set_follow_viewport

## If [code]true[/code], [Parallax2D]'s position is not affected by the position of the camera.
var ignore_camera_scroll: bool:
	get = is_ignore_camera_scroll, set = set_ignore_camera_scroll

## Top-left limits for scrolling to begin. If the camera is outside of this limit, the [Parallax2D] stops scrolling. Must be lower than [member limit_end] minus the viewport size to work.
var limit_begin: Vector2:
	get = get_limit_begin, set = set_limit_begin

## Bottom-right limits for scrolling to end. If the camera is outside of this limit, the [Parallax2D] will stop scrolling. Must be higher than [member limit_begin] and the viewport size combined to work.
var limit_end: Vector2:
	get = get_limit_end, set = set_limit_end

var physics_interpolation_mode: int:
	get = get_physics_interpolation_mode, set = set_physics_interpolation_mode

## Repeats the [Texture2D] of each of this node's children and offsets them by this value. When scrolling, the node's position loops, giving the illusion of an infinite scrolling background if the values are larger than the screen size. If an axis is set to [code]0[/code], the [Texture2D] will not be repeated.
var repeat_size: Vector2:
	get = get_repeat_size, set = set_repeat_size

## Overrides the amount of times the texture repeats. Each texture copy spreads evenly from the original by [member repeat_size]. Useful for when zooming out with a camera.
var repeat_times: int:
	get = get_repeat_times, set = set_repeat_times

## Offset used to scroll this [Parallax2D]. This value is updated automatically unless [member ignore_camera_scroll] is [code]true[/code].
var screen_offset: Vector2:
	get = get_screen_offset, set = set_screen_offset

## The [Parallax2D]'s offset. Similar to [member screen_offset] and [member Node2D.position], but will not be overridden.
## [b]Note:[/b] Values will loop if [member repeat_size] is set higher than [code]0[/code].
var scroll_offset: Vector2:
	get = get_scroll_offset, set = set_scroll_offset

## Multiplier to the final [Parallax2D]'s offset. Can be used to simulate distance from the camera.
## For example, a value of [code]1[/code] scrolls at the same speed as the camera. A value greater than [code]1[/code] scrolls faster, making objects appear closer. Less than [code]1[/code] scrolls slower, making objects appear further, and a value of [code]0[/code] stops the objects completely.
var scroll_scale: Vector2:
	get = get_scroll_scale, set = set_scroll_scale




func get_autoscroll() -> Vector2:
	return autoscroll

func set_autoscroll(value: Vector2) -> void:
	autoscroll = value

func get_follow_viewport() -> bool:
	return follow_viewport

func set_follow_viewport(value: bool) -> void:
	follow_viewport = value

func is_ignore_camera_scroll() -> bool:
	return ignore_camera_scroll

func set_ignore_camera_scroll(value: bool) -> void:
	ignore_camera_scroll = value

func get_limit_begin() -> Vector2:
	return limit_begin

func set_limit_begin(value: Vector2) -> void:
	limit_begin = value

func get_limit_end() -> Vector2:
	return limit_end

func set_limit_end(value: Vector2) -> void:
	limit_end = value

func get_physics_interpolation_mode() -> int:
	return physics_interpolation_mode

func set_physics_interpolation_mode(value: int) -> void:
	physics_interpolation_mode = value

func get_repeat_size() -> Vector2:
	return repeat_size

func set_repeat_size(value: Vector2) -> void:
	repeat_size = value

func get_repeat_times() -> int:
	return repeat_times

func set_repeat_times(value: int) -> void:
	repeat_times = value

func get_screen_offset() -> Vector2:
	return screen_offset

func set_screen_offset(value: Vector2) -> void:
	screen_offset = value

func get_scroll_offset() -> Vector2:
	return scroll_offset

func set_scroll_offset(value: Vector2) -> void:
	scroll_offset = value

func get_scroll_scale() -> Vector2:
	return scroll_scale

func set_scroll_scale(value: Vector2) -> void:
	scroll_scale = value

