extends Resource
class_name OpenXRIPBinding

## Defines a binding between an [OpenXRAction] and an XR input or output.
##
## This binding resource binds an [OpenXRAction] to an input or output. As most controllers have left hand and right versions that are handled by the same interaction profile we can specify multiple bindings. For instance an action "Fire" could be bound to both "/user/hand/left/input/trigger" and "/user/hand/right/input/trigger". This would require two binding entries.



## [OpenXRAction] that is bound to [member binding_path].
var action: OpenXRAction:
	get = get_action, set = set_action

## Binding modifiers for this binding.
var binding_modifiers: Array:
	get = get_binding_modifiers, set = set_binding_modifiers

## Binding path that defines the input or output bound to [member action].
## [b]Note:[/b] Binding paths are suggestions, an XR runtime may choose to bind the action to a different input or output emulating this input or output.
var binding_path: String:
	get = get_binding_path, set = set_binding_path

## Paths that define the inputs or outputs bound on the device.
var paths: PackedStringArray:
	get = get_paths, set = set_paths



## Add an input/output path to this binding.
func add_path(path: String) -> void:
	pass;

## Get the [OpenXRBindingModifier] at this index.
func get_binding_modifier(index: int) -> OpenXRActionBindingModifier:
	pass;

## Get the number of binding modifiers for this binding.
func get_binding_modifier_count() -> int:
	pass;

## Get the number of input/output paths in this binding.
func get_path_count() -> int:
	pass;

## Returns [code]true[/code] if this input/output path is part of this binding.
func has_path(path: String) -> bool:
	pass;

## Removes this input/output path from this binding.
func remove_path(path: String) -> void:
	pass;


func get_action() -> OpenXRAction:
	return action

func set_action(value: OpenXRAction) -> void:
	action = value

func get_binding_modifiers() -> Array:
	return binding_modifiers

func set_binding_modifiers(value: Array) -> void:
	binding_modifiers = value

func get_binding_path() -> String:
	return binding_path

func set_binding_path(value: String) -> void:
	binding_path = value

func get_paths() -> PackedStringArray:
	return paths

func set_paths(value: PackedStringArray) -> void:
	paths = value

