extends RefCounted
class_name OpenXRFutureResult

## Result object tracking the asynchronous result of an OpenXR Future object.
##
## Result object tracking the asynchronous result of an OpenXR Future object, you can use this object to track the result status.


## Emitted when the asynchronous function is finished or has been cancelled.
signal completed(result: OpenXRFutureResult)
## The asynchronous function is running.
## The asynchronous function has finished.
## The asynchronous function has been cancelled.

#enum ResultStatus
enum {
    RESULT_RUNNING = 0,
    RESULT_FINISHED = 1,
    RESULT_CANCELLED = 2,
}


## Cancel this future, this will interrupt and stop the asynchronous function.
func cancel_future() -> void:
	pass;

## Return the [code]XrFutureEXT[/code] value this result relates to.
func get_future() -> int:
	pass;

## Returns the result value of our asynchronous function (if set by the extension). The type of this result value depends on the function being called. Consult the documentation of the relevant function.
func get_result_value() -> Variant:
	pass;

## Returns the status of this result.
func get_status() -> int:
	pass;

## Stores the result value we expose to the user.
## [b]Note:[/b] This method should only be called by an OpenXR extension that implements an asynchronous function.
func set_result_value(result_value: Variant) -> void:
	pass;


