extends OpenXRExtensionWrapper
class_name OpenXRFutureExtension

## The OpenXR Future extension allows for asynchronous APIs to be used.
##
## This is a support extension in OpenXR that allows other OpenXR extensions to start asynchronous functions and get a callback after this function finishes. It is not intended for consumption within GDScript but can be accessed from GDExtension.





## Cancels an in-progress future. [param future] must be an [code]XrFutureEXT[/code] value previously returned by an API that started an asynchronous function.
func cancel_future(future: int) -> void:
	pass;

## Returns [code]true[/code] if futures are available in the OpenXR runtime used. This function will only return a usable result after OpenXR has been initialized.
func is_active() -> bool:
	pass;

## Register an OpenXR Future object so we monitor for completion. [param future] must be an [code]XrFutureEXT[/code] value previously returned by an API that started an asynchronous function.
## You can optionally specify [param on_success], it will be invoked on successful completion of the future.
## Or you can use the returned [OpenXRFutureResult] object to [code]await[/code] its [signal OpenXRFutureResult.completed] signal.
## [codeblock]
## var future_result = OpenXRFutureExtension.register_future(future)
## await future_result.completed
## if future_result.get_status() == OpenXRFutureResult.RESULT_FINISHED:
## # Handle your success
## pass
## [/codeblock]
func register_future(future: int, on_success: Callable = Callable()) -> OpenXRFutureResult:
	pass;


