extends Object
class_name OpenXRExtensionWrapper

## Allows implementing OpenXR extensions with GDExtension.
##
## [OpenXRExtensionWrapper] allows implementing OpenXR extensions with GDExtension. The extension should be registered with [method register_extension_wrapper].





## Returns a pointer to an [code]XrCompositionLayerBaseHeader[/code] struct to provide the given composition layer.
## This will only be called if the extension previously registered itself with [method OpenXRAPIExtension.register_composition_layer_provider].
func _get_composition_layer(index: int) -> int:
	pass;

## Returns the number of composition layers this extension wrapper provides via [method _get_composition_layer].
## This will only be called if the extension previously registered itself with [method OpenXRAPIExtension.register_composition_layer_provider].
func _get_composition_layer_count() -> int:
	pass;

## Returns an integer that will be used to sort the given composition layer provided via [method _get_composition_layer]. Lower numbers will move the layer to the front of the list, and higher numbers to the end. The default projection layer has an order of [code]0[/code], so layers provided by this method should probably be above or below (but not exactly) [code]0[/code].
## This will only be called if the extension previously registered itself with [method OpenXRAPIExtension.register_composition_layer_provider].
func _get_composition_layer_order(index: int) -> int:
	pass;

## Returns a [Dictionary] of OpenXR extensions related to this extension. The [Dictionary] should contain the name of the extension, mapped to a [code]bool *[/code] cast to an integer:
## - If the [code]bool *[/code] is a [code]nullptr[/code] this extension is mandatory.
## - If the [code]bool *[/code] points to a boolean, the boolean will be updated to [code]true[/code] if the extension is enabled.
func _get_requested_extensions() -> Dictionary:
	pass;

## Returns a [PackedStringArray] of positional tracker names that are used within the extension wrapper.
func _get_suggested_tracker_names() -> PackedStringArray:
	pass;

## Gets an array of [Dictionary]s that represent properties, just like [method Object._get_property_list], that will be added to [OpenXRCompositionLayer] nodes.
func _get_viewport_composition_layer_extension_properties() -> Array[Dictionary]:
	pass;

## Gets a [Dictionary] containing the default values for the properties returned by [method _get_viewport_composition_layer_extension_properties].
func _get_viewport_composition_layer_extension_property_defaults() -> Dictionary:
	pass;

## Called before the OpenXR instance is created.
func _on_before_instance_created() -> void:
	pass;

## Called when there is an OpenXR event to process. When implementing, return [code]true[/code] if the event was handled, return [code]false[/code] otherwise.
func _on_event_polled(event: const void*) -> bool:
	pass;

## Called right after the OpenXR instance is created.
func _on_instance_created(instance: int) -> void:
	pass;

## Called right before the OpenXR instance is destroyed.
func _on_instance_destroyed() -> void:
	pass;

## Called right after the main swapchains are (re)created.
func _on_main_swapchains_created() -> void:
	pass;

## Called right after the given viewport is rendered.
## [b]Note:[/b] The draw commands might only be queued at this point, not executed.
func _on_post_draw_viewport(viewport: RID) -> void:
	pass;

## Called right before the given viewport is rendered.
func _on_pre_draw_viewport(viewport: RID) -> void:
	pass;

## Called right before the XR viewports begin their rendering step.
func _on_pre_render() -> void:
	pass;

## Called as part of the OpenXR process handling. This happens right before general and physics processing steps of the main loop. During this step controller data is queried and made available to game logic.
func _on_process() -> void:
	pass;

## Allows extensions to register additional controller metadata. This function is called even when the OpenXR API is not constructed as the metadata needs to be available to the editor.
## Extensions should also provide metadata regardless of whether they are supported on the host system. The controller data is used to setup action maps for users who may have access to the relevant hardware.
func _on_register_metadata() -> void:
	pass;

## Called right after the OpenXR session is created.
func _on_session_created(session: int) -> void:
	pass;

## Called right before the OpenXR session is destroyed.
func _on_session_destroyed() -> void:
	pass;

## Called when the OpenXR session state is changed to exiting.
func _on_state_exiting() -> void:
	pass;

## Called when the OpenXR session state is changed to focused. This state is the active state when the game runs.
func _on_state_focused() -> void:
	pass;

## Called when the OpenXR session state is changed to idle.
func _on_state_idle() -> void:
	pass;

## Called when the OpenXR session state is changed to loss pending.
func _on_state_loss_pending() -> void:
	pass;

## Called when the OpenXR session state is changed to ready. This means OpenXR is ready to set up the session.
func _on_state_ready() -> void:
	pass;

## Called when the OpenXR session state is changed to stopping.
func _on_state_stopping() -> void:
	pass;

## Called when the OpenXR session state is changed to synchronized. OpenXR also returns to this state when the application loses focus.
func _on_state_synchronized() -> void:
	pass;

## Called when the OpenXR session state is changed to visible. This means OpenXR is now ready to receive frames.
func _on_state_visible() -> void:
	pass;

## Called when a composition layer created via [OpenXRCompositionLayer] is destroyed.
## [param layer] is a pointer to an [code]XrCompositionLayerBaseHeader[/code] struct.
func _on_viewport_composition_layer_destroyed(layer: const void*) -> void:
	pass;

## Adds additional data structures to Android surface swapchains created by [OpenXRCompositionLayer].
## [param property_values] contains the values of the properties returned by [method _get_viewport_composition_layer_extension_properties].
func _set_android_surface_swapchain_create_info_and_get_next_pointer(property_values: Dictionary, next_pointer: void*) -> int:
	pass;

## Adds additional data structures to [code]XrFrameEndInfo[/code].
## This will only be called if the extension previously registered itself with [method OpenXRAPIExtension.register_frame_info_extension].
func _set_frame_end_info_and_get_next_pointer(next_pointer: void*) -> int:
	pass;

## Adds additional data structures to [code]XrFrameWaitInfo[/code].
## This will only be called if the extension previously registered itself with [method OpenXRAPIExtension.register_frame_info_extension].
func _set_frame_wait_info_and_get_next_pointer(next_pointer: void*) -> int:
	pass;

## Adds additional data structures when each hand tracker is created.
func _set_hand_joint_locations_and_get_next_pointer(hand_index: int, next_pointer: void*) -> int:
	pass;

## Adds additional data structures when the OpenXR instance is created.
func _set_instance_create_info_and_get_next_pointer(next_pointer: void*) -> int:
	pass;

## Adds additional data structures to the projection view of the given [param view_index].
func _set_projection_views_and_get_next_pointer(view_index: int, next_pointer: void*) -> int:
	pass;

## Adds additional data structures to [code]XrReferenceSpaceCreateInfo[/code].
func _set_reference_space_create_info_and_get_next_pointer(reference_space_type: int, next_pointer: void*) -> int:
	pass;

## Adds additional data structures when the OpenXR session is created.
func _set_session_create_and_get_next_pointer(next_pointer: void*) -> int:
	pass;

## Adds additional data structures when creating OpenXR swapchains.
func _set_swapchain_create_info_and_get_next_pointer(next_pointer: void*) -> int:
	pass;

## Adds additional data structures when querying OpenXR system abilities.
func _set_system_properties_and_get_next_pointer(next_pointer: void*) -> int:
	pass;

## Adds additional data structures to [code]XrViewLocateInfo[/code].
## This will only be called if the extension previously registered itself with [method OpenXRAPIExtension.register_frame_info_extension].
func _set_view_locate_info_and_get_next_pointer(next_pointer: void*) -> int:
	pass;

## Adds additional data structures to composition layers created by [OpenXRCompositionLayer].
## [param property_values] contains the values of the properties returned by [method _get_viewport_composition_layer_extension_properties].
## [param layer] is a pointer to an [code]XrCompositionLayerBaseHeader[/code] struct.
func _set_viewport_composition_layer_and_get_next_pointer(layer: const void*, property_values: Dictionary, next_pointer: void*) -> int:
	pass;

## Returns the created [OpenXRAPIExtension], which can be used to access the OpenXR API.
func get_openxr_api() -> OpenXRAPIExtension:
	pass;

## Registers the extension. This should happen at core module initialization level.
func register_extension_wrapper() -> void:
	pass;


