extends OpenXRCompositionLayer
class_name OpenXRCompositionLayerEquirect

## An OpenXR composition layer that is rendered as an internal slice of a sphere.
##
## An OpenXR composition layer that allows rendering a [SubViewport] on an internal slice of a sphere.



## The central horizontal angle of the sphere. Used to set the width.
var central_horizontal_angle: float:
	get = get_central_horizontal_angle, set = set_central_horizontal_angle

## The number of segments to use in the fallback mesh.
var fallback_segments: int:
	get = get_fallback_segments, set = set_fallback_segments

## The lower vertical angle of the sphere. Used (together with [member upper_vertical_angle]) to set the height.
var lower_vertical_angle: float:
	get = get_lower_vertical_angle, set = set_lower_vertical_angle

## The radius of the sphere.
var radius: float:
	get = get_radius, set = set_radius

## The upper vertical angle of the sphere. Used (together with [member lower_vertical_angle]) to set the height.
var upper_vertical_angle: float:
	get = get_upper_vertical_angle, set = set_upper_vertical_angle




func get_central_horizontal_angle() -> float:
	return central_horizontal_angle

func set_central_horizontal_angle(value: float) -> void:
	central_horizontal_angle = value

func get_fallback_segments() -> int:
	return fallback_segments

func set_fallback_segments(value: int) -> void:
	fallback_segments = value

func get_lower_vertical_angle() -> float:
	return lower_vertical_angle

func set_lower_vertical_angle(value: float) -> void:
	lower_vertical_angle = value

func get_radius() -> float:
	return radius

func set_radius(value: float) -> void:
	radius = value

func get_upper_vertical_angle() -> float:
	return upper_vertical_angle

func set_upper_vertical_angle(value: float) -> void:
	upper_vertical_angle = value

