extends RefCounted
class_name Logger

## Custom logger to receive messages from the internal error/warning stream.
##
## Custom logger to receive messages from the internal error/warning stream. Loggers are registered via [method OS.add_logger].


## The message received is an error.
## The message received is a warning.
## The message received is a script error.
## The message received is a shader error.

#enum ErrorType
enum {
    ERROR_TYPE_ERROR = 0,
    ERROR_TYPE_WARNING = 1,
    ERROR_TYPE_SCRIPT = 2,
    ERROR_TYPE_SHADER = 3,
}


## Called when an error is logged. The error provides the [param function], [param file], and [param line] that it originated from, as well as either the [param code] that generated the error or a [param rationale].
## The type of error provided by [param error_type] is described in the [enum ErrorType] enumeration.
## Additionally, [param script_backtraces] provides backtraces for each of the script languages. These will only contain stack frames in editor builds and debug builds by default. To enable them for release builds as well, you need to enable [member ProjectSettings.debug/settings/gdscript/always_track_call_stacks].
## [b]Warning:[/b] This function may be called from multiple different threads, so you may need to do your own locking.
## [b]Note:[/b] [param script_backtraces] will not contain any captured variables, due to its prohibitively high cost. To get those you will need to capture the backtraces yourself, from within the [Logger] virtual methods, using [method Engine.capture_script_backtraces].
func _log_error(function: String, file: String, line: int, code: String, rationale: String, editor_notify: bool, error_type: int, script_backtraces: Array[ScriptBacktrace]) -> void:
	pass;

## Called when a message is logged. If [param error] is [code]true[/code], then this message was meant to be sent to [code]stderr[/code].
## [b]Warning:[/b] This function may be called from multiple different threads, so you may need to do your own locking.
func _log_message(message: String, error: bool) -> void:
	pass;


