extends Resource
class_name LightmapGIData

## Contains baked lightmap and dynamic object probe data for [LightmapGI].
##
## [LightmapGIData] contains baked lightmap and dynamic object probe data for [LightmapGI]. It is replaced every time lightmaps are baked in [LightmapGI].


## Shadowmasking is disabled. No shadowmask texture will be created when baking lightmaps. Existing shadowmask textures will be removed during baking.
## Shadowmasking is enabled. Directional shadows that are outside the [member DirectionalLight3D.directional_shadow_max_distance] will be rendered using the shadowmask texture. Shadows that are inside the range will be rendered using real-time shadows exclusively. This mode allows for more precise real-time shadows up close, without the potential "smearing" effect that can occur when using lightmaps with a high texel size. The downside is that when the camera moves fast, the transition between the real-time light and shadowmask can be obvious. Also, objects that only have shadows baked in the shadowmask (and no real-time shadows) won't display any shadows up close.
## Shadowmasking is enabled. Directional shadows will be rendered with real-time shadows overlaid on top of the shadowmask texture. This mode makes for smoother shadow transitions when the camera moves fast, at the cost of a potential smearing effect for directional shadows that are up close (due to the real-time shadow being mixed with a low-resolution shadowmask). Objects that only have shadows baked in the shadowmask (and no real-time shadows) will keep their shadows up close.

#enum ShadowmaskMode
enum {
    SHADOWMASK_MODE_NONE = 0,
    SHADOWMASK_MODE_REPLACE = 1,
    SHADOWMASK_MODE_OVERLAY = 2,
}
## The lightmap atlas texture generated by the lightmapper.
var light_texture: TextureLayered:
	get = get_light_texture, set = set_light_texture

## The lightmap atlas textures generated by the lightmapper.
var lightmap_textures: Array[TextureLayered]:
	get = get_lightmap_textures, set = set_lightmap_textures

## The shadowmask atlas textures generated by the lightmapper.
var shadowmask_textures: Array[TextureLayered]:
	get = get_shadowmask_textures, set = set_shadowmask_textures



## Adds an object that is considered baked within this [LightmapGIData].
func add_user(path: NodePath, uv_scale: Rect2, slice_index: int, sub_instance: int) -> void:
	pass;

## Clear all objects that are considered baked within this [LightmapGIData].
func clear_users() -> void:
	pass;

## Returns the number of objects that are considered baked within this [LightmapGIData].
func get_user_count() -> int:
	pass;

## Returns the [NodePath] of the baked object at index [param user_idx].
func get_user_path(user_idx: int) -> NodePath:
	pass;

## If [code]true[/code], lightmaps were baked with directional information. See also [member LightmapGI.directional].
func is_using_spherical_harmonics() -> bool:
	pass;

## If [param uses_spherical_harmonics] is [code]true[/code], tells the engine to treat the lightmap data as if it was baked with directional information.
## [b]Note:[/b] Changing this value on already baked lightmaps will not cause them to be baked again. This means the material appearance will look incorrect until lightmaps are baked again, in which case the value set here is discarded as the entire [LightmapGIData] resource is replaced by the lightmapper.
func set_uses_spherical_harmonics(uses_spherical_harmonics: bool) -> void:
	pass;


func get_light_texture() -> TextureLayered:
	return light_texture

func set_light_texture(value: TextureLayered) -> void:
	light_texture = value

func get_lightmap_textures() -> Array[TextureLayered]:
	return lightmap_textures

func set_lightmap_textures(value: Array[TextureLayered]) -> void:
	lightmap_textures = value

func get_shadowmask_textures() -> Array[TextureLayered]:
	return shadowmask_textures

func set_shadowmask_textures(value: Array[TextureLayered]) -> void:
	shadowmask_textures = value

