extends Resource
class_name LabelSettings

## Provides common settings to customize the text in a [Label].
##
## [LabelSettings] is a resource that provides common settings to customize the text in a [Label]. It will take priority over the properties defined in [member Control.theme]. The resource can be shared between multiple labels and changed on the fly, so it's convenient and flexible way to setup text style.



## [Font] used for the text.
var font: Font:
	get = get_font, set = set_font

## Color of the text.
var font_color: Color:
	get = get_font_color, set = set_font_color

## Size of the text.
var font_size: int:
	get = get_font_size, set = set_font_size

## Additional vertical spacing between lines (in pixels), spacing is added to line descent. This value can be negative.
var line_spacing: float:
	get = get_line_spacing, set = set_line_spacing

## The color of the outline.
var outline_color: Color:
	get = get_outline_color, set = set_outline_color

## Text outline size.
var outline_size: int:
	get = get_outline_size, set = set_outline_size

## Vertical space between paragraphs. Added on top of [member line_spacing].
var paragraph_spacing: float:
	get = get_paragraph_spacing, set = set_paragraph_spacing

## Color of the shadow effect. If alpha is [code]0[/code], no shadow will be drawn.
var shadow_color: Color:
	get = get_shadow_color, set = set_shadow_color

## Offset of the shadow effect, in pixels.
var shadow_offset: Vector2:
	get = get_shadow_offset, set = set_shadow_offset

## Size of the shadow effect.
var shadow_size: int:
	get = get_shadow_size, set = set_shadow_size

## The number of stacked outlines.
var stacked_outline_count: int:
	get = get_stacked_outline_count, set = set_stacked_outline_count

## Returns the stacked shadow count.
var stacked_shadow_count: int:
	get = get_stacked_shadow_count, set = set_stacked_shadow_count



## Adds a new stacked outline to the label at the given [param index]. If [param index] is [code]-1[/code], the new stacked outline will be added at the end of the list.
func add_stacked_outline(index: int = -1) -> void:
	pass;

## Adds a new stacked shadow to the label at the given [param index]. If [param index] is [code]-1[/code], the new stacked shadow will be added at the end of the list.
func add_stacked_shadow(index: int = -1) -> void:
	pass;

## Returns the color of the stacked outline at [param index].
func get_stacked_outline_color(index: int) -> Color:
	pass;

## Returns the size of the stacked outline at [param index].
func get_stacked_outline_size(index: int) -> int:
	pass;

## Returns the color of the stacked shadow at [param index].
func get_stacked_shadow_color(index: int) -> Color:
	pass;

## Returns the offset of the stacked shadow at [param index].
func get_stacked_shadow_offset(index: int) -> Vector2:
	pass;

## Returns the outline size of the stacked shadow at [param index].
func get_stacked_shadow_outline_size(index: int) -> int:
	pass;

## Moves the stacked outline at index [param from_index] to the given position [param to_position] in the array.
func move_stacked_outline(from_index: int, to_position: int) -> void:
	pass;

## Moves the stacked shadow at index [param from_index] to the given position [param to_position] in the array.
func move_stacked_shadow(from_index: int, to_position: int) -> void:
	pass;

## Removes the stacked outline at index [param index].
func remove_stacked_outline(index: int) -> void:
	pass;

## Removes the stacked shadow at index [param index].
func remove_stacked_shadow(index: int) -> void:
	pass;

## Sets the color of the stacked outline identified by the given [param index] to [param color].
func set_stacked_outline_color(index: int, color: Color) -> void:
	pass;

## Sets the size of the stacked outline identified by the given [param index] to [param size].
func set_stacked_outline_size(index: int, size: int) -> void:
	pass;

## Sets the color of the stacked shadow identified by the given [param index] to [param color].
func set_stacked_shadow_color(index: int, color: Color) -> void:
	pass;

## Sets the offset of the stacked shadow identified by the given [param index] to [param offset].
func set_stacked_shadow_offset(index: int, offset: Vector2) -> void:
	pass;

## Sets the outline size of the stacked shadow identified by the given [param index] to [param size].
func set_stacked_shadow_outline_size(index: int, size: int) -> void:
	pass;


func get_font() -> Font:
	return font

func set_font(value: Font) -> void:
	font = value

func get_font_color() -> Color:
	return font_color

func set_font_color(value: Color) -> void:
	font_color = value

func get_font_size() -> int:
	return font_size

func set_font_size(value: int) -> void:
	font_size = value

func get_line_spacing() -> float:
	return line_spacing

func set_line_spacing(value: float) -> void:
	line_spacing = value

func get_outline_color() -> Color:
	return outline_color

func set_outline_color(value: Color) -> void:
	outline_color = value

func get_outline_size() -> int:
	return outline_size

func set_outline_size(value: int) -> void:
	outline_size = value

func get_paragraph_spacing() -> float:
	return paragraph_spacing

func set_paragraph_spacing(value: float) -> void:
	paragraph_spacing = value

func get_shadow_color() -> Color:
	return shadow_color

func set_shadow_color(value: Color) -> void:
	shadow_color = value

func get_shadow_offset() -> Vector2:
	return shadow_offset

func set_shadow_offset(value: Vector2) -> void:
	shadow_offset = value

func get_shadow_size() -> int:
	return shadow_size

func set_shadow_size(value: int) -> void:
	shadow_size = value

func get_stacked_outline_count() -> int:
	return stacked_outline_count

func set_stacked_outline_count(value: int) -> void:
	stacked_outline_count = value

func get_stacked_shadow_count() -> int:
	return stacked_shadow_count

func set_stacked_shadow_count(value: int) -> void:
	stacked_shadow_count = value

