extends Control
class_name Label

## A control for displaying plain text.
##
## A control for displaying plain text. It gives you control over the horizontal and vertical alignment and can wrap the text inside the node's bounding rectangle. It doesn't support bold, italics, or other rich text formatting. For that, use [RichTextLabel] instead.
##
## @tutorial(2D Dodge The Creeps Demo): https://godotengine.org/asset-library/asset/2712



## If set to something other than [constant TextServer.AUTOWRAP_OFF], the text gets wrapped inside the node's bounding rectangle. If you resize the node, it will change its height automatically to show all the text.
var autowrap_mode: int:
	get = get_autowrap_mode, set = set_autowrap_mode

## Autowrap space trimming flags. See [constant TextServer.BREAK_TRIM_START_EDGE_SPACES] and [constant TextServer.BREAK_TRIM_END_EDGE_SPACES] for more info.
var autowrap_trim_flags: int:
	get = get_autowrap_trim_flags, set = set_autowrap_trim_flags

## If [code]true[/code], the Label only shows the text that fits inside its bounding rectangle and will clip text horizontally.
var clip_text: bool:
	get = is_clipping_text, set = set_clip_text

## Ellipsis character used for text clipping.
var ellipsis_char: String:
	get = get_ellipsis_char, set = set_ellipsis_char

## Controls the text's horizontal alignment. Supports left, center, right, and fill (also known as justify).
var horizontal_alignment: int:
	get = get_horizontal_alignment, set = set_horizontal_alignment

## Line fill alignment rules.
var justification_flags: int:
	get = get_justification_flags, set = set_justification_flags

## A [LabelSettings] resource that can be shared between multiple [Label] nodes. Takes priority over theme properties.
var label_settings: LabelSettings:
	get = get_label_settings, set = set_label_settings

## Language code used for line-breaking and text shaping algorithms, if left empty current locale is used instead.
var language: String:
	get = get_language, set = set_language

## The number of the lines ignored and not displayed from the start of the [member text] value.
var lines_skipped: int:
	get = get_lines_skipped, set = set_lines_skipped

## Limits the lines of text the node shows on screen.
var max_lines_visible: int:
	get = get_max_lines_visible, set = set_max_lines_visible

var mouse_filter: int:
	get = get_mouse_filter, set = set_mouse_filter

## String used as a paragraph separator. Each paragraph is processed independently, in its own BiDi context.
var paragraph_separator: String:
	get = get_paragraph_separator, set = set_paragraph_separator

var size_flags_vertical: int:
	get = get_v_size_flags, set = set_v_size_flags

## Set BiDi algorithm override for the structured text.
var structured_text_bidi_override: int:
	get = get_structured_text_bidi_override, set = set_structured_text_bidi_override

## Set additional options for BiDi override.
var structured_text_bidi_override_options: Array:
	get = get_structured_text_bidi_override_options, set = set_structured_text_bidi_override_options

## Aligns text to the given tab-stops.
var tab_stops: PackedFloat32Array:
	get = get_tab_stops, set = set_tab_stops

## The text to display on screen.
var text: String:
	get = get_text, set = set_text

## Base text writing direction.
var text_direction: int:
	get = get_text_direction, set = set_text_direction

## The clipping behavior when the text exceeds the node's bounding rectangle.
var text_overrun_behavior: int:
	get = get_text_overrun_behavior, set = set_text_overrun_behavior

## If [code]true[/code], all the text displays as UPPERCASE.
var uppercase: bool:
	get = is_uppercase, set = set_uppercase

## Controls the text's vertical alignment. Supports top, center, bottom, and fill.
var vertical_alignment: int:
	get = get_vertical_alignment, set = set_vertical_alignment

## The number of characters to display. If set to [code]-1[/code], all characters are displayed. This can be useful when animating the text appearing in a dialog box.
## [b]Note:[/b] Setting this property updates [member visible_ratio] accordingly.
var visible_characters: int:
	get = get_visible_characters, set = set_visible_characters

## The clipping behavior when [member visible_characters] or [member visible_ratio] is set.
var visible_characters_behavior: int:
	get = get_visible_characters_behavior, set = set_visible_characters_behavior

## The fraction of characters to display, relative to the total number of characters (see [method get_total_character_count]). If set to [code]1.0[/code], all characters are displayed. If set to [code]0.5[/code], only half of the characters will be displayed. This can be useful when animating the text appearing in a dialog box.
## [b]Note:[/b] Setting this property updates [member visible_characters] accordingly.
var visible_ratio: float:
	get = get_visible_ratio, set = set_visible_ratio



## Returns the bounding rectangle of the character at position [param pos] in the label's local coordinate system. If the character is a non-visual character or [param pos] is outside the valid range, an empty [Rect2] is returned. If the character is a part of a composite grapheme, the bounding rectangle of the whole grapheme is returned.
func get_character_bounds(pos: int) -> Rect2:
	pass;

## Returns the number of lines of text the Label has.
func get_line_count() -> int:
	pass;

## Returns the height of the line [param line].
## If [param line] is set to [code]-1[/code], returns the biggest line height.
## If there are no lines, returns font size in pixels.
func get_line_height(line: int = -1) -> int:
	pass;

## Returns the total number of printable characters in the text (excluding spaces and newlines).
func get_total_character_count() -> int:
	pass;

## Returns the number of lines shown. Useful if the [Label]'s height cannot currently display all lines.
func get_visible_line_count() -> int:
	pass;


func get_autowrap_mode() -> int:
	return autowrap_mode

func set_autowrap_mode(value: int) -> void:
	autowrap_mode = value

func get_autowrap_trim_flags() -> int:
	return autowrap_trim_flags

func set_autowrap_trim_flags(value: int) -> void:
	autowrap_trim_flags = value

func is_clipping_text() -> bool:
	return clip_text

func set_clip_text(value: bool) -> void:
	clip_text = value

func get_ellipsis_char() -> String:
	return ellipsis_char

func set_ellipsis_char(value: String) -> void:
	ellipsis_char = value

func get_horizontal_alignment() -> int:
	return horizontal_alignment

func set_horizontal_alignment(value: int) -> void:
	horizontal_alignment = value

func get_justification_flags() -> int:
	return justification_flags

func set_justification_flags(value: int) -> void:
	justification_flags = value

func get_label_settings() -> LabelSettings:
	return label_settings

func set_label_settings(value: LabelSettings) -> void:
	label_settings = value

func get_language() -> String:
	return language

func set_language(value: String) -> void:
	language = value

func get_lines_skipped() -> int:
	return lines_skipped

func set_lines_skipped(value: int) -> void:
	lines_skipped = value

func get_max_lines_visible() -> int:
	return max_lines_visible

func set_max_lines_visible(value: int) -> void:
	max_lines_visible = value

func get_mouse_filter() -> int:
	return mouse_filter

func set_mouse_filter(value: int) -> void:
	mouse_filter = value

func get_paragraph_separator() -> String:
	return paragraph_separator

func set_paragraph_separator(value: String) -> void:
	paragraph_separator = value

func get_v_size_flags() -> int:
	return size_flags_vertical

func set_v_size_flags(value: int) -> void:
	size_flags_vertical = value

func get_structured_text_bidi_override() -> int:
	return structured_text_bidi_override

func set_structured_text_bidi_override(value: int) -> void:
	structured_text_bidi_override = value

func get_structured_text_bidi_override_options() -> Array:
	return structured_text_bidi_override_options

func set_structured_text_bidi_override_options(value: Array) -> void:
	structured_text_bidi_override_options = value

func get_tab_stops() -> PackedFloat32Array:
	return tab_stops

func set_tab_stops(value: PackedFloat32Array) -> void:
	tab_stops = value

func get_text() -> String:
	return text

func set_text(value: String) -> void:
	text = value

func get_text_direction() -> int:
	return text_direction

func set_text_direction(value: int) -> void:
	text_direction = value

func get_text_overrun_behavior() -> int:
	return text_overrun_behavior

func set_text_overrun_behavior(value: int) -> void:
	text_overrun_behavior = value

func is_uppercase() -> bool:
	return uppercase

func set_uppercase(value: bool) -> void:
	uppercase = value

func get_vertical_alignment() -> int:
	return vertical_alignment

func set_vertical_alignment(value: int) -> void:
	vertical_alignment = value

func get_visible_characters() -> int:
	return visible_characters

func set_visible_characters(value: int) -> void:
	visible_characters = value

func get_visible_characters_behavior() -> int:
	return visible_characters_behavior

func set_visible_characters_behavior(value: int) -> void:
	visible_characters_behavior = value

func get_visible_ratio() -> float:
	return visible_ratio

func set_visible_ratio(value: float) -> void:
	visible_ratio = value

