extends Node3D
class_name Joint3D

## Abstract base class for all 3D physics joints.
##
## Abstract base class for all joints in 3D physics. 3D joints bind together two physics bodies ([member node_a] and [member node_b]) and apply a constraint. If only one body is defined, it is attached to a fixed [StaticBody3D] without collision shapes.
##
## @tutorial(3D Truck Town Demo): https://godotengine.org/asset-library/asset/2752



## If [code]true[/code], the two bodies bound together do not collide with each other.
var exclude_nodes_from_collision: bool:
	get = get_exclude_nodes_from_collision, set = set_exclude_nodes_from_collision

## Path to the first node (A) attached to the joint. The node must inherit [PhysicsBody3D].
## If left empty and [member node_b] is set, the body is attached to a fixed [StaticBody3D] without collision shapes.
var node_a: NodePath:
	get = get_node_a, set = set_node_a

## Path to the second node (B) attached to the joint. The node must inherit [PhysicsBody3D].
## If left empty and [member node_a] is set, the body is attached to a fixed [StaticBody3D] without collision shapes.
var node_b: NodePath:
	get = get_node_b, set = set_node_b

## The priority used to define which solver is executed first for multiple joints. The lower the value, the higher the priority.
var solver_priority: int:
	get = get_solver_priority, set = set_solver_priority



## Returns the joint's internal [RID] from the [PhysicsServer3D].
func get_rid() -> RID:
	pass;


func get_exclude_nodes_from_collision() -> bool:
	return exclude_nodes_from_collision

func set_exclude_nodes_from_collision(value: bool) -> void:
	exclude_nodes_from_collision = value

func get_node_a() -> NodePath:
	return node_a

func set_node_a(value: NodePath) -> void:
	node_a = value

func get_node_b() -> NodePath:
	return node_b

func set_node_b(value: NodePath) -> void:
	node_b = value

func get_solver_priority() -> int:
	return solver_priority

func set_solver_priority(value: int) -> void:
	solver_priority = value

