extends InputEventMouse
class_name InputEventMouseMotion

## Represents a mouse or a pen movement.
##
## Stores information about a mouse or a pen motion. This includes relative position, absolute position, and velocity. See [method Node._input].
## [b]Note:[/b] By default, this event is only emitted once per frame rendered at most. If you need more precise input reporting, set [member Input.use_accumulated_input] to [code]false[/code] to make events emitted as often as possible. If you use InputEventMouseMotion to draw lines, consider using [method Geometry2D.bresenham_line] as well to avoid visible gaps in lines if the user is moving the mouse quickly.
## [b]Note:[/b] This event may be emitted even when the mouse hasn't moved, either by the operating system or by Godot itself. If you really need to know if the mouse has moved (e.g. to suppress displaying a tooltip), you should check that [code]relative.is_zero_approx()[/code] is [code]false[/code].
##
## @tutorial(Using InputEvent): https://docs.godotengine.org/en/stable/tutorials/inputs/inputevent.html
## @tutorial(Mouse and input coordinates): https://docs.godotengine.org/en/stable/tutorials/inputs/mouse_and_input_coordinates.html
## @tutorial(3D Voxel Demo): https://godotengine.org/asset-library/asset/2755



## Returns [code]true[/code] when using the eraser end of a stylus pen.
## [b]Note:[/b] This property is implemented on Linux, macOS and Windows.
var pen_inverted: bool:
	get = get_pen_inverted, set = set_pen_inverted

## Represents the pressure the user puts on the pen. Ranges from [code]0.0[/code] to [code]1.0[/code].
var pressure: float:
	get = get_pressure, set = set_pressure

## The mouse position relative to the previous position (position at the last frame).
## [b]Note:[/b] Since [InputEventMouseMotion] may only be emitted when the mouse moves, it is not possible to reliably detect when the mouse has stopped moving by checking this property. A separate, short timer may be necessary.
## [b]Note:[/b] [member relative] is automatically scaled according to the content scale factor, which is defined by the project's stretch mode settings. This means mouse sensitivity will appear different depending on resolution when using [member relative] in a script that handles mouse aiming with the [constant Input.MOUSE_MODE_CAPTURED] mouse mode. To avoid this, use [member screen_relative] instead.
var relative: Vector2:
	get = get_relative, set = set_relative

## The unscaled mouse position relative to the previous position in the coordinate system of the screen (position at the last frame).
## [b]Note:[/b] Since [InputEventMouseMotion] may only be emitted when the mouse moves, it is not possible to reliably detect when the mouse has stopped moving by checking this property. A separate, short timer may be necessary.
## [b]Note:[/b] This coordinate is [i]not[/i] scaled according to the content scale factor or calls to [method InputEvent.xformed_by]. This should be preferred over [member relative] for mouse aiming when using the [constant Input.MOUSE_MODE_CAPTURED] mouse mode, regardless of the project's stretch mode.
var screen_relative: Vector2:
	get = get_screen_relative, set = set_screen_relative

## The unscaled mouse velocity in pixels per second in screen coordinates. This velocity is [i]not[/i] scaled according to the content scale factor or calls to [method InputEvent.xformed_by].
## [b]Note:[/b] Use [member screen_relative] for mouse aiming using the [constant Input.MOUSE_MODE_CAPTURED] mouse mode.
var screen_velocity: Vector2:
	get = get_screen_velocity, set = set_screen_velocity

## Represents the angles of tilt of the pen. Positive X-coordinate value indicates a tilt to the right. Positive Y-coordinate value indicates a tilt toward the user. Ranges from [code]-1.0[/code] to [code]1.0[/code] for both axes.
var tilt: Vector2:
	get = get_tilt, set = set_tilt

## The mouse velocity in pixels per second.
## [b]Note:[/b] [member velocity] is automatically scaled according to the content scale factor, which is defined by the project's stretch mode settings. That means mouse sensitivity may appear different depending on resolution.
## [b]Note:[/b] Use [member screen_relative] for mouse aiming using the [constant Input.MOUSE_MODE_CAPTURED] mouse mode.
var velocity: Vector2:
	get = get_velocity, set = set_velocity




func get_pen_inverted() -> bool:
	return pen_inverted

func set_pen_inverted(value: bool) -> void:
	pen_inverted = value

func get_pressure() -> float:
	return pressure

func set_pressure(value: float) -> void:
	pressure = value

func get_relative() -> Vector2:
	return relative

func set_relative(value: Vector2) -> void:
	relative = value

func get_screen_relative() -> Vector2:
	return screen_relative

func set_screen_relative(value: Vector2) -> void:
	screen_relative = value

func get_screen_velocity() -> Vector2:
	return screen_velocity

func set_screen_velocity(value: Vector2) -> void:
	screen_velocity = value

func get_tilt() -> Vector2:
	return tilt

func set_tilt(value: Vector2) -> void:
	tilt = value

func get_velocity() -> Vector2:
	return velocity

func set_velocity(value: Vector2) -> void:
	velocity = value

