extends Resource
class_name InputEvent

## Abstract base class for input events.
##
## Abstract base class of all types of input events. See [method Node._input].
##
## @tutorial(Using InputEvent): https://docs.godotengine.org/en/stable/tutorials/inputs/inputevent.html
## @tutorial(Viewport and canvas transforms): https://docs.godotengine.org/en/stable/tutorials/2d/2d_transforms.html
## @tutorial(2D Dodge The Creeps Demo): https://godotengine.org/asset-library/asset/2712
## @tutorial(3D Voxel Demo): https://godotengine.org/asset-library/asset/2755


## Device ID used for emulated mouse input from a touchscreen, or for emulated touch input from a mouse. This can be used to distinguish emulated mouse input from physical mouse input, or emulated touch input from physical touch input.
const DEVICE_ID_EMULATION = -1;


## The event's device ID.
## [b]Note:[/b] [member device] can be negative for special use cases that don't refer to devices physically present on the system. See [constant DEVICE_ID_EMULATION].
var device: int:
	get = get_device, set = set_device



## Returns [code]true[/code] if the given input event and this input event can be added together (only for events of type [InputEventMouseMotion]).
## The given input event's position, global position and speed will be copied. The resulting [code]relative[/code] is a sum of both events. Both events' modifiers have to be identical.
func accumulate(with_event: InputEvent) -> bool:
	pass;

## Returns a [String] representation of the event.
func as_text() -> String:
	pass;

## Returns a value between 0.0 and 1.0 depending on the given actions' state. Useful for getting the value of events of type [InputEventJoypadMotion].
## If [param exact_match] is [code]false[/code], it ignores additional input modifiers for [InputEventKey] and [InputEventMouseButton] events, and the direction for [InputEventJoypadMotion] events.
func get_action_strength(action: StringName, exact_match: bool = false) -> float:
	pass;

## Returns [code]true[/code] if this input event matches a pre-defined action of any type.
## If [param exact_match] is [code]false[/code], it ignores additional input modifiers for [InputEventKey] and [InputEventMouseButton] events, and the direction for [InputEventJoypadMotion] events.
func is_action(action: StringName, exact_match: bool = false) -> bool:
	pass;

## Returns [code]true[/code] if the given action is being pressed (and is not an echo event for [InputEventKey] events, unless [param allow_echo] is [code]true[/code]). Not relevant for events of type [InputEventMouseMotion] or [InputEventScreenDrag].
## If [param exact_match] is [code]false[/code], it ignores additional input modifiers for [InputEventKey] and [InputEventMouseButton] events, and the direction for [InputEventJoypadMotion] events.
## [b]Note:[/b] Due to keyboard ghosting, [method is_action_pressed] may return [code]false[/code] even if one of the action's keys is pressed. See [url=$DOCS_URL/tutorials/inputs/input_examples.html#keyboard-events]Input examples[/url] in the documentation for more information.
func is_action_pressed(action: StringName, allow_echo: bool = false, exact_match: bool = false) -> bool:
	pass;

## Returns [code]true[/code] if the given action is released (i.e. not pressed). Not relevant for events of type [InputEventMouseMotion] or [InputEventScreenDrag].
## If [param exact_match] is [code]false[/code], it ignores additional input modifiers for [InputEventKey] and [InputEventMouseButton] events, and the direction for [InputEventJoypadMotion] events.
func is_action_released(action: StringName, exact_match: bool = false) -> bool:
	pass;

## Returns [code]true[/code] if this input event's type is one that can be assigned to an input action.
func is_action_type() -> bool:
	pass;

## Returns [code]true[/code] if this input event has been canceled.
func is_canceled() -> bool:
	pass;

## Returns [code]true[/code] if this input event is an echo event (only for events of type [InputEventKey]). An echo event is a repeated key event sent when the user is holding down the key. Any other event type returns [code]false[/code].
## [b]Note:[/b] The rate at which echo events are sent is typically around 20 events per second (after holding down the key for roughly half a second). However, the key repeat delay/speed can be changed by the user or disabled entirely in the operating system settings. To ensure your project works correctly on all configurations, do not assume the user has a specific key repeat configuration in your project's behavior.
func is_echo() -> bool:
	pass;

## Returns [code]true[/code] if the specified [param event] matches this event. Only valid for action events i.e key ([InputEventKey]), button ([InputEventMouseButton] or [InputEventJoypadButton]), axis [InputEventJoypadMotion] or action ([InputEventAction]) events.
## If [param exact_match] is [code]false[/code], it ignores additional input modifiers for [InputEventKey] and [InputEventMouseButton] events, and the direction for [InputEventJoypadMotion] events.
## [b]Note:[/b] Only considers the event configuration (such as the keyboard key or joypad axis), not state information like [method is_pressed], [method is_released], [method is_echo], or [method is_canceled].
func is_match(event: InputEvent, exact_match: bool = true) -> bool:
	pass;

## Returns [code]true[/code] if this input event is pressed. Not relevant for events of type [InputEventMouseMotion] or [InputEventScreenDrag].
## [b]Note:[/b] Due to keyboard ghosting, [method is_pressed] may return [code]false[/code] even if one of the action's keys is pressed. See [url=$DOCS_URL/tutorials/inputs/input_examples.html#keyboard-events]Input examples[/url] in the documentation for more information.
func is_pressed() -> bool:
	pass;

## Returns [code]true[/code] if this input event is released. Not relevant for events of type [InputEventMouseMotion] or [InputEventScreenDrag].
func is_released() -> bool:
	pass;

## Returns a copy of the given input event which has been offset by [param local_ofs] and transformed by [param xform]. Relevant for events of type [InputEventMouseButton], [InputEventMouseMotion], [InputEventScreenTouch], [InputEventScreenDrag], [InputEventMagnifyGesture] and [InputEventPanGesture].
func xformed_by(xform: Transform2D, local_ofs: Vector2 = Vector2(0, 0)) -> InputEvent:
	pass;


func get_device() -> int:
	return device

func set_device(value: int) -> void:
	device = value

