extends Node3D
class_name ImporterMeshInstance3D




var cast_shadow: int:
	get = get_cast_shadows_setting, set = set_cast_shadows_setting

var layer_mask: int:
	get = get_layer_mask, set = set_layer_mask

var mesh: ImporterMesh:
	get = get_mesh, set = set_mesh

var skeleton_path: NodePath:
	get = get_skeleton_path, set = set_skeleton_path

var skin: Skin:
	get = get_skin, set = set_skin

var visibility_range_begin: float:
	get = get_visibility_range_begin, set = set_visibility_range_begin

var visibility_range_begin_margin: float:
	get = get_visibility_range_begin_margin, set = set_visibility_range_begin_margin

var visibility_range_end: float:
	get = get_visibility_range_end, set = set_visibility_range_end

var visibility_range_end_margin: float:
	get = get_visibility_range_end_margin, set = set_visibility_range_end_margin

var visibility_range_fade_mode: int:
	get = get_visibility_range_fade_mode, set = set_visibility_range_fade_mode




func get_cast_shadows_setting() -> int:
	return cast_shadow

func set_cast_shadows_setting(value: int) -> void:
	cast_shadow = value

func get_layer_mask() -> int:
	return layer_mask

func set_layer_mask(value: int) -> void:
	layer_mask = value

func get_mesh() -> ImporterMesh:
	return mesh

func set_mesh(value: ImporterMesh) -> void:
	mesh = value

func get_skeleton_path() -> NodePath:
	return skeleton_path

func set_skeleton_path(value: NodePath) -> void:
	skeleton_path = value

func get_skin() -> Skin:
	return skin

func set_skin(value: Skin) -> void:
	skin = value

func get_visibility_range_begin() -> float:
	return visibility_range_begin

func set_visibility_range_begin(value: float) -> void:
	visibility_range_begin = value

func get_visibility_range_begin_margin() -> float:
	return visibility_range_begin_margin

func set_visibility_range_begin_margin(value: float) -> void:
	visibility_range_begin_margin = value

func get_visibility_range_end() -> float:
	return visibility_range_end

func set_visibility_range_end(value: float) -> void:
	visibility_range_end = value

func get_visibility_range_end_margin() -> float:
	return visibility_range_end_margin

func set_visibility_range_end_margin(value: float) -> void:
	visibility_range_end_margin = value

func get_visibility_range_fade_mode() -> int:
	return visibility_range_fade_mode

func set_visibility_range_fade_mode(value: int) -> void:
	visibility_range_fade_mode = value

