extends Object
class_name IP

## Internet protocol (IP) support functions such as DNS resolution.
##
## IP contains support functions for the Internet Protocol (IP). TCP/IP support is in different classes (see [StreamPeerTCP] and [TCPServer]). IP provides DNS hostname resolution support, both blocking and threaded.


## DNS hostname resolver status: No status.
## DNS hostname resolver status: Waiting.
## DNS hostname resolver status: Done.
## DNS hostname resolver status: Error.
## Maximum number of concurrent DNS resolver queries allowed, [constant RESOLVER_INVALID_ID] is returned if exceeded.
const RESOLVER_MAX_QUERIES = 256;

## Invalid ID constant. Returned if [constant RESOLVER_MAX_QUERIES] is exceeded.
const RESOLVER_INVALID_ID = -1;

## Address type: None.
## Address type: Internet protocol version 4 (IPv4).
## Address type: Internet protocol version 6 (IPv6).
## Address type: Any.

#enum ResolverStatus
enum {
    RESOLVER_STATUS_NONE = 0,
    RESOLVER_STATUS_WAITING = 1,
    RESOLVER_STATUS_DONE = 2,
    RESOLVER_STATUS_ERROR = 3,
}
#enum Type
enum {
    TYPE_NONE = 0,
    TYPE_IPV4 = 1,
    TYPE_IPV6 = 2,
    TYPE_ANY = 3,
}


## Removes all of a [param hostname]'s cached references. If no [param hostname] is given, all cached IP addresses are removed.
func clear_cache(hostname: String = "") -> void:
	pass;

## Removes a given item [param id] from the queue. This should be used to free a queue after it has completed to enable more queries to happen.
func erase_resolve_item(id: int) -> void:
	pass;

## Returns all the user's current IPv4 and IPv6 addresses as an array.
func get_local_addresses() -> PackedStringArray:
	pass;

## Returns all network adapters as an array.
## Each adapter is a dictionary of the form:
## [codeblock]
## {
## "index": "1", # Interface index.
## "name": "eth0", # Interface name.
## "friendly": "Ethernet One", # A friendly name (might be empty).
## "addresses": ["192.168.1.101"], # An array of IP addresses associated to this interface.
## }
## [/codeblock]
func get_local_interfaces() -> Array[Dictionary]:
	pass;

## Returns a queued hostname's IP address, given its queue [param id]. Returns an empty string on error or if resolution hasn't happened yet (see [method get_resolve_item_status]).
func get_resolve_item_address(id: int) -> String:
	pass;

## Returns resolved addresses, or an empty array if an error happened or resolution didn't happen yet (see [method get_resolve_item_status]).
func get_resolve_item_addresses(id: int) -> Array:
	pass;

## Returns a queued hostname's status as a [enum ResolverStatus] constant, given its queue [param id].
func get_resolve_item_status(id: int) -> int:
	pass;

## Returns a given hostname's IPv4 or IPv6 address when resolved (blocking-type method). The address type returned depends on the [enum Type] constant given as [param ip_type].
func resolve_hostname(host: String, ip_type: int = 3) -> String:
	pass;

## Resolves a given hostname in a blocking way. Addresses are returned as an [Array] of IPv4 or IPv6 addresses depending on [param ip_type].
func resolve_hostname_addresses(host: String, ip_type: int = 3) -> PackedStringArray:
	pass;

## Creates a queue item to resolve a hostname to an IPv4 or IPv6 address depending on the [enum Type] constant given as [param ip_type]. Returns the queue ID if successful, or [constant RESOLVER_INVALID_ID] on error.
func resolve_hostname_queue_item(host: String, ip_type: int = 3) -> int:
	pass;


