extends Shape3D
class_name HeightMapShape3D

## A 3D height map shape used for physics collision.
##
## A 3D heightmap shape, intended for use in physics. Usually used to provide a shape for a [CollisionShape3D]. This type is most commonly used for terrain with vertices placed in a fixed width grid. Due to the nature of the heightmap, it cannot be used to model overhangs or caves, which would require multiple vertices at the same vertical location. Holes can be punched through the collision by assigning [constant @GDScript.NAN] to the height of the desired vertices (this is supported in both GodotPhysics3D and Jolt Physics). You could then insert meshes with their own separate collision to provide overhangs, caves, and so on.
## [b]Performance:[/b] [HeightMapShape3D] is faster to check collisions against than [ConcavePolygonShape3D], but it is significantly slower than primitive shapes like [BoxShape3D].
## A heightmap collision shape can also be built by using an [Image] reference:
## [codeblocks]
## [gdscript]
## var heightmap_texture = ResourceLoader.load("res://heightmap_image.exr")
## var heightmap_image = heightmap_texture.get_image()
## heightmap_image.convert(Image.FORMAT_RF)
## var height_min = 0.0
## var height_max = 10.0
## update_map_data_from_image(heightmap_image, height_min, height_max)
## [/gdscript]
## [/codeblocks]



## Height map data. The array's size must be equal to [member map_width] multiplied by [member map_depth].
var map_data: PackedFloat32Array:
	get = get_map_data, set = set_map_data

## Number of vertices in the depth of the height map. Changing this will resize the [member map_data].
var map_depth: int:
	get = get_map_depth, set = set_map_depth

## Number of vertices in the width of the height map. Changing this will resize the [member map_data].
var map_width: int:
	get = get_map_width, set = set_map_width



## Returns the largest height value found in [member map_data]. Recalculates only when [member map_data] changes.
func get_max_height() -> float:
	pass;

## Returns the smallest height value found in [member map_data]. Recalculates only when [member map_data] changes.
func get_min_height() -> float:
	pass;

## Updates [member map_data] with data read from an [Image] reference. Automatically resizes heightmap [member map_width] and [member map_depth] to fit the full image width and height.
## The image needs to be in either [constant Image.FORMAT_RF] (32 bit), [constant Image.FORMAT_RH] (16 bit), or [constant Image.FORMAT_R8] (8 bit).
## Each image pixel is read in as a float on the range from [code]0.0[/code] (black pixel) to [code]1.0[/code] (white pixel). This range value gets remapped to [param height_min] and [param height_max] to form the final height value.
## [b]Note:[/b] Using a heightmap with 16-bit or 32-bit data, stored in EXR or HDR format is recommended. Using 8-bit height data, or a format like PNG that Godot imports as 8-bit, will result in a terraced terrain.
func update_map_data_from_image(image: Image, height_min: float, height_max: float) -> void:
	pass;


func get_map_data() -> PackedFloat32Array:
	return map_data

func set_map_data(value: PackedFloat32Array) -> void:
	map_data = value

func get_map_depth() -> int:
	return map_depth

func set_map_depth(value: int) -> void:
	map_depth = value

func get_map_width() -> int:
	return map_width

func set_map_width(value: int) -> void:
	map_width = value

