extends Resource
class_name Gradient

## A color transition.
##
## This resource describes a color transition by defining a set of colored points and how to interpolate between them.
## See also [Curve] which supports more complex easing methods, but does not support colors.


## Linear interpolation.
## Constant interpolation, color changes abruptly at each point and stays uniform between. This might cause visible aliasing when used for a gradient texture in some cases.
## Cubic interpolation.
## sRGB color space.
## Linear sRGB color space.
## [url=https://bottosson.github.io/posts/oklab/]Oklab[/url] color space. This color space provides a smooth and uniform-looking transition between colors.

#enum InterpolationMode
enum {
    GRADIENT_INTERPOLATE_LINEAR = 0,
    GRADIENT_INTERPOLATE_CONSTANT = 1,
    GRADIENT_INTERPOLATE_CUBIC = 2,
}
#enum ColorSpace
enum {
    GRADIENT_COLOR_SPACE_SRGB = 0,
    GRADIENT_COLOR_SPACE_LINEAR_SRGB = 1,
    GRADIENT_COLOR_SPACE_OKLAB = 2,
}
## Gradient's colors as a [PackedColorArray].
## [b]Note:[/b] Setting this property updates all colors at once. To update any color individually use [method set_color].
var colors: PackedColorArray:
	get = get_colors, set = set_colors

## The color space used to interpolate between points of the gradient. It does not affect the returned colors, which will always be in sRGB space.
## [b]Note:[/b] This setting has no effect when [member interpolation_mode] is set to [constant GRADIENT_INTERPOLATE_CONSTANT].
var interpolation_color_space: int:
	get = get_interpolation_color_space, set = set_interpolation_color_space

## The algorithm used to interpolate between points of the gradient.
var interpolation_mode: int:
	get = get_interpolation_mode, set = set_interpolation_mode

## Gradient's offsets as a [PackedFloat32Array].
## [b]Note:[/b] Setting this property updates all offsets at once. To update any offset individually use [method set_offset].
var offsets: PackedFloat32Array:
	get = get_offsets, set = set_offsets



## Adds the specified color to the gradient, with the specified offset.
func add_point(offset: float, color: Color) -> void:
	pass;

## Returns the color of the gradient color at index [param point].
func get_color(point: int) -> Color:
	pass;

## Returns the offset of the gradient color at index [param point].
func get_offset(point: int) -> float:
	pass;

## Returns the number of colors in the gradient.
func get_point_count() -> int:
	pass;

## Removes the color at index [param point].
func remove_point(point: int) -> void:
	pass;

## Reverses/mirrors the gradient.
## [b]Note:[/b] This method mirrors all points around the middle of the gradient, which may produce unexpected results when [member interpolation_mode] is set to [constant GRADIENT_INTERPOLATE_CONSTANT].
func reverse() -> void:
	pass;

## Returns the interpolated color specified by [param offset].
func sample(offset: float) -> Color:
	pass;

## Sets the color of the gradient color at index [param point].
func set_color(point: int, color: Color) -> void:
	pass;

## Sets the offset for the gradient color at index [param point].
func set_offset(point: int, offset: float) -> void:
	pass;


func get_colors() -> PackedColorArray:
	return colors

func set_colors(value: PackedColorArray) -> void:
	colors = value

func get_interpolation_color_space() -> int:
	return interpolation_color_space

func set_interpolation_color_space(value: int) -> void:
	interpolation_color_space = value

func get_interpolation_mode() -> int:
	return interpolation_mode

func set_interpolation_mode(value: int) -> void:
	interpolation_mode = value

func get_offsets() -> PackedFloat32Array:
	return offsets

func set_offsets(value: PackedFloat32Array) -> void:
	offsets = value

