extends Resource
class_name GLTFMesh

## GLTFMesh represents a glTF mesh.
##
## GLTFMesh handles 3D mesh data imported from glTF files. It includes properties for blend channels, blend weights, instance materials, and the mesh itself.
##
## @tutorial(Runtime file loading and saving): https://docs.godotengine.org/en/stable/tutorials/io/runtime_file_loading_and_saving.html



## An array of floats representing the blend weights of the mesh.
var blend_weights: PackedFloat32Array:
	get = get_blend_weights, set = set_blend_weights

## An array of Material objects representing the materials used in the mesh.
var instance_materials: Array[Material]:
	get = get_instance_materials, set = set_instance_materials

## The [ImporterMesh] object representing the mesh itself.
var mesh: ImporterMesh:
	get = get_mesh, set = set_mesh

## The original name of the mesh.
var original_name: String:
	get = get_original_name, set = set_original_name



## Gets additional arbitrary data in this [GLTFMesh] instance. This can be used to keep per-node state data in [GLTFDocumentExtension] classes, which is important because they are stateless.
## The argument should be the [GLTFDocumentExtension] name (does not have to match the extension name in the glTF file), and the return value can be anything you set. If nothing was set, the return value is [code]null[/code].
func get_additional_data(extension_name: StringName) -> Variant:
	pass;

## Sets additional arbitrary data in this [GLTFMesh] instance. This can be used to keep per-node state data in [GLTFDocumentExtension] classes, which is important because they are stateless.
## The first argument should be the [GLTFDocumentExtension] name (does not have to match the extension name in the glTF file), and the second argument can be anything you want.
func set_additional_data(extension_name: StringName, additional_data: Variant) -> void:
	pass;


func get_blend_weights() -> PackedFloat32Array:
	return blend_weights

func set_blend_weights(value: PackedFloat32Array) -> void:
	blend_weights = value

func get_instance_materials() -> Array[Material]:
	return instance_materials

func set_instance_materials(value: Array[Material]) -> void:
	instance_materials = value

func get_mesh() -> ImporterMesh:
	return mesh

func set_mesh(value: ImporterMesh) -> void:
	mesh = value

func get_original_name() -> String:
	return original_name

func set_original_name(value: String) -> void:
	original_name = value

