extends Resource
class_name FoldableGroup

## A group of foldable containers that doesn't allow more than one container to be expanded at a time.
##
## A group of [FoldableContainer]-derived nodes. Only one container can be expanded at a time.


## Emitted when one of the containers of the group is expanded.
signal expanded(container: FoldableContainer)

## If [code]true[/code], it is possible to fold all containers in this FoldableGroup.
var allow_folding_all: bool:
	get = is_allow_folding_all, set = set_allow_folding_all

var resource_local_to_scene: bool:
	get = is_local_to_scene, set = set_local_to_scene



## Returns an [Array] of [FoldableContainer]s that have this as their FoldableGroup (see [member FoldableContainer.foldable_group]). This is equivalent to [ButtonGroup] but for FoldableContainers.
func get_containers() -> Array[FoldableContainer]:
	pass;

## Returns the current expanded container.
func get_expanded_container() -> FoldableContainer:
	pass;


func is_allow_folding_all() -> bool:
	return allow_folding_all

func set_allow_folding_all(value: bool) -> void:
	allow_folding_all = value

func is_local_to_scene() -> bool:
	return resource_local_to_scene

func set_local_to_scene(value: bool) -> void:
	resource_local_to_scene = value

