extends Container
class_name FoldableContainer

## A container that can be expanded/collapsed.
##
## A container that can be expanded/collapsed, with a title that can be filled with controls, such as buttons.
## The title can be positioned at the top or bottom of the container.
## The container can be expanded or collapsed by clicking the title or by pressing [code]ui_accept[/code] when focused.
## Child control nodes are hidden when the container is collapsed. Ignores non-control children.
## Can allow grouping with other FoldableContainers, check [member foldable_group] and [FoldableGroup].


## Emitted when the container is folded/expanded.
signal folding_changed(is_folded: bool)
## Makes the title appear at the top of the container.
## Makes the title appear at the bottom of the container. Also makes all StyleBoxes flipped vertically.

#enum TitlePosition
enum {
    POSITION_TOP = 0,
    POSITION_BOTTOM = 1,
}
var focus_mode: int:
	get = get_focus_mode, set = set_focus_mode

## The [FoldableGroup] associated with the container. When multiple [FoldableContainer] nodes share the same group, only one of them is allowed to be unfolded.
var foldable_group: FoldableGroup:
	get = get_foldable_group, set = set_foldable_group

## If [code]true[/code], the container will becomes folded and will hide all its children.
var folded: bool:
	get = is_folded, set = set_folded

## Language code used for text shaping algorithms. If left empty, current locale is used instead.
var language: String:
	get = get_language, set = set_language

var mouse_filter: int:
	get = get_mouse_filter, set = set_mouse_filter

## The container's title text.
var title: String:
	get = get_title, set = set_title

## Title's horizontal text alignment as defined in the [enum HorizontalAlignment] enum.
var title_alignment: int:
	get = get_title_alignment, set = set_title_alignment

## Title's position as defined in the [enum TitlePosition] enum.
var title_position: int:
	get = get_title_position, set = set_title_position

## Title text writing direction.
var title_text_direction: int:
	get = get_title_text_direction, set = set_title_text_direction

## Defines the behavior of the title when the text is longer than the available space.
var title_text_overrun_behavior: int:
	get = get_title_text_overrun_behavior, set = set_title_text_overrun_behavior



## Adds a [Control] that will be placed next to the container's title, obscuring the clickable area. Prime usage is adding [Button] nodes, but it can be any [Control].
## The control will be added as a child of this container and removed from previous parent if necessary. The controls will be placed aligned to the right, with the first added control being the leftmost one.
func add_title_bar_control(control: Control) -> void:
	pass;

## Expands the container and emits [signal folding_changed].
func expand() -> void:
	pass;

## Folds the container and emits [signal folding_changed].
func fold() -> void:
	pass;

## Removes a [Control] added with [method add_title_bar_control]. The node is not freed automatically, you need to use [method Node.queue_free].
func remove_title_bar_control(control: Control) -> void:
	pass;


func get_focus_mode() -> int:
	return focus_mode

func set_focus_mode(value: int) -> void:
	focus_mode = value

func get_foldable_group() -> FoldableGroup:
	return foldable_group

func set_foldable_group(value: FoldableGroup) -> void:
	foldable_group = value

func is_folded() -> bool:
	return folded

func set_folded(value: bool) -> void:
	folded = value

func get_language() -> String:
	return language

func set_language(value: String) -> void:
	language = value

func get_mouse_filter() -> int:
	return mouse_filter

func set_mouse_filter(value: int) -> void:
	mouse_filter = value

func get_title() -> String:
	return title

func set_title(value: String) -> void:
	title = value

func get_title_alignment() -> int:
	return title_alignment

func set_title_alignment(value: int) -> void:
	title_alignment = value

func get_title_position() -> int:
	return title_position

func set_title_position(value: int) -> void:
	title_position = value

func get_title_text_direction() -> int:
	return title_text_direction

func set_title_text_direction(value: int) -> void:
	title_text_direction = value

func get_title_text_overrun_behavior() -> int:
	return title_text_overrun_behavior

func set_title_text_overrun_behavior(value: int) -> void:
	title_text_overrun_behavior = value

