extends Container
class_name FlowContainer

## A container that arranges its child controls horizontally or vertically and wraps them around at the borders.
##
## A container that arranges its child controls horizontally or vertically and wraps them around at the borders. This is similar to how text in a book wraps around when no more words can fit on a line.
##
## @tutorial(Using Containers): https://docs.godotengine.org/en/stable/tutorials/ui/gui_containers.html


## The child controls will be arranged at the beginning of the container, i.e. top if orientation is vertical, left if orientation is horizontal (right for RTL layout).
## The child controls will be centered in the container.
## The child controls will be arranged at the end of the container, i.e. bottom if orientation is vertical, right if orientation is horizontal (left for RTL layout).
## The last partially filled row or column will wrap aligned to the previous row or column in accordance with [member alignment].
## The last partially filled row or column will wrap aligned to the beginning of the previous row or column.
## The last partially filled row or column will wrap aligned to the center of the previous row or column.
## The last partially filled row or column will wrap aligned to the end of the previous row or column.

#enum AlignmentMode
enum {
    ALIGNMENT_BEGIN = 0,
    ALIGNMENT_CENTER = 1,
    ALIGNMENT_END = 2,
}
#enum LastWrapAlignmentMode
enum {
    LAST_WRAP_ALIGNMENT_INHERIT = 0,
    LAST_WRAP_ALIGNMENT_BEGIN = 1,
    LAST_WRAP_ALIGNMENT_CENTER = 2,
    LAST_WRAP_ALIGNMENT_END = 3,
}
## The alignment of the container's children (must be one of [constant ALIGNMENT_BEGIN], [constant ALIGNMENT_CENTER], or [constant ALIGNMENT_END]).
var alignment: int:
	get = get_alignment, set = set_alignment

## The wrap behavior of the last, partially filled row or column (must be one of [constant LAST_WRAP_ALIGNMENT_INHERIT], [constant LAST_WRAP_ALIGNMENT_BEGIN], [constant LAST_WRAP_ALIGNMENT_CENTER], or [constant LAST_WRAP_ALIGNMENT_END]).
var last_wrap_alignment: int:
	get = get_last_wrap_alignment, set = set_last_wrap_alignment

## If [code]true[/code], reverses fill direction. Horizontal [FlowContainer]s will fill rows bottom to top, vertical [FlowContainer]s will fill columns right to left.
## When using a vertical [FlowContainer] with a right to left [member Control.layout_direction], columns will fill left to right instead.
var reverse_fill: bool:
	get = is_reverse_fill, set = set_reverse_fill

## If [code]true[/code], the [FlowContainer] will arrange its children vertically, rather than horizontally.
## Can't be changed when using [HFlowContainer] and [VFlowContainer].
var vertical: bool:
	get = is_vertical, set = set_vertical



## Returns the current line count.
func get_line_count() -> int:
	pass;


func get_alignment() -> int:
	return alignment

func set_alignment(value: int) -> void:
	alignment = value

func get_last_wrap_alignment() -> int:
	return last_wrap_alignment

func set_last_wrap_alignment(value: int) -> void:
	last_wrap_alignment = value

func is_reverse_fill() -> bool:
	return reverse_fill

func set_reverse_fill(value: bool) -> void:
	reverse_fill = value

func is_vertical() -> bool:
	return vertical

func set_vertical(value: bool) -> void:
	vertical = value

