extends Texture2D
class_name ExternalTexture

## Texture which displays the content of an external buffer.
##
## Displays the content of an external buffer provided by the platform.
## Requires the [url=https://registry.khronos.org/OpenGL/extensions/OES/OES_EGL_image_external.txt]OES_EGL_image_external[/url] extension (OpenGL) or [url=https://registry.khronos.org/vulkan/specs/1.1-extensions/html/vkspec.html#VK_ANDROID_external_memory_android_hardware_buffer]VK_ANDROID_external_memory_android_hardware_buffer[/url] extension (Vulkan).
## [b]Note:[/b] This is currently only supported in Android builds.



var resource_local_to_scene: bool:
	get = is_local_to_scene, set = set_local_to_scene

## External texture size.
var size: Vector2:
	get = get_size, set = set_size



## Returns the external texture ID.
## Depending on your use case, you may need to pass this to platform APIs, for example, when creating an [code]android.graphics.SurfaceTexture[/code] on Android.
func get_external_texture_id() -> int:
	pass;

## Sets the external buffer ID.
## Depending on your use case, you may need to call this with data received from a platform API, for example, [code]SurfaceTexture.getHardwareBuffer()[/code] on Android.
func set_external_buffer_id(external_buffer_id: int) -> void:
	pass;


func is_local_to_scene() -> bool:
	return resource_local_to_scene

func set_local_to_scene(value: bool) -> void:
	resource_local_to_scene = value

func get_size() -> Vector2:
	return size

func set_size(value: Vector2) -> void:
	size = value

