extends Object
class_name EditorSelection

## Manages the SceneTree selection in the editor.
##
## This object manages the SceneTree selection in the editor.
## [b]Note:[/b] This class shouldn't be instantiated directly. Instead, access the singleton using [method EditorInterface.get_selection].


## Emitted when the selection changes.
signal selection_changed



## Adds a node to the selection.
## [b]Note:[/b] The newly selected node will not be automatically edited in the inspector. If you want to edit a node, use [method EditorInterface.edit_node].
func add_node(node: Node) -> void:
	pass;

## Clear the selection.
func clear() -> void:
	pass;

## Returns the list of selected nodes.
func get_selected_nodes() -> Array[Node]:
	pass;

## Returns the list of top selected nodes only, excluding any children. This is useful for performing transform operations (moving them, rotating, etc.).
## For example, if there is a node A with a child B and a sibling C, then selecting all three will cause this method to return only A and C. Changing the global transform of A will affect the global transform of B, so there is no need to change B separately.
func get_top_selected_nodes() -> Array[Node]:
	pass;

## Returns the list of top selected nodes only, excluding any children. This is useful for performing transform operations (moving them, rotating, etc.). See [method get_top_selected_nodes].
func get_transformable_selected_nodes() -> Array[Node]:
	pass;

## Removes a node from the selection.
func remove_node(node: Node) -> void:
	pass;


