extends RefCounted
class_name EditorExportPreset

## Export preset configuration.
##
## Export preset configuration. Instances of [EditorExportPreset] by editor UI and intended to be used a read-only configuration passed to the [EditorExportPlatform] methods when exporting the project.



#enum ExportFilter
enum {
    EXPORT_ALL_RESOURCES = 0,
    EXPORT_SELECTED_SCENES = 1,
    EXPORT_SELECTED_RESOURCES = 2,
    EXCLUDE_SELECTED_RESOURCES = 3,
    EXPORT_CUSTOMIZED = 4,
}
#enum FileExportMode
enum {
    MODE_FILE_NOT_CUSTOMIZED = 0,
    MODE_FILE_STRIP = 1,
    MODE_FILE_KEEP = 2,
    MODE_FILE_REMOVE = 3,
}
#enum ScriptExportMode
enum {
    MODE_SCRIPT_TEXT = 0,
    MODE_SCRIPT_BINARY_TOKENS = 1,
    MODE_SCRIPT_BINARY_TOKENS_COMPRESSED = 2,
}


## Returns [code]true[/code] if "Advanced" toggle is enabled in the export dialog.
func are_advanced_options_enabled() -> bool:
	pass;

## Returns string with a comma separated list of custom features.
func get_custom_features() -> String:
	pass;

## Returns [Dictionary] of files selected in the "Resources" tab of the export dialog. Dictionary keys are file names and values are export mode - [code]"strip"[/code], [code]"keep"[/code], or [code]"remove"[/code]. See also [method get_file_export_mode].
func get_customized_files() -> Dictionary:
	pass;

## Returns number of files selected in the "Resources" tab of the export dialog.
func get_customized_files_count() -> int:
	pass;

## Returns [code]true[/code] if PCK directory encryption is enabled in the export dialog.
func get_encrypt_directory() -> bool:
	pass;

## Returns [code]true[/code] if PCK encryption is enabled in the export dialog.
func get_encrypt_pck() -> bool:
	pass;

## Returns file filters to exclude during PCK encryption.
func get_encryption_ex_filter() -> String:
	pass;

## Returns file filters to include during PCK encryption.
func get_encryption_in_filter() -> String:
	pass;

## Returns PCK encryption key.
func get_encryption_key() -> String:
	pass;

## Returns file filters to exclude during export.
func get_exclude_filter() -> String:
	pass;

## Returns export file filter mode selected in the "Resources" tab of the export dialog.
func get_export_filter() -> int:
	pass;

## Returns export target path.
func get_export_path() -> String:
	pass;

## Returns file export mode for the specified file.
func get_file_export_mode(path: String, default: int = 0) -> int:
	pass;

## Returns array of files to export.
func get_files_to_export() -> PackedStringArray:
	pass;

## Returns file filters to include during export.
func get_include_filter() -> String:
	pass;

## Returns export option value or value of environment variable if it is set.
func get_or_env(name: StringName, env_var: String) -> Variant:
	pass;

## Returns the list of packs on which to base a patch export on.
func get_patches() -> PackedStringArray:
	pass;

## Returns export preset name.
func get_preset_name() -> String:
	pass;

## Returns the value of the setting identified by [param name] using export preset feature tag overrides instead of current OS features.
func get_project_setting(name: StringName) -> Variant:
	pass;

## Returns script export mode.
func get_script_export_mode() -> int:
	pass;

## Returns the preset's version number, or fall back to the [member ProjectSettings.application/config/version] project setting if set to an empty string.
## If [param windows_version] is [code]true[/code], formats the returned version number to be compatible with Windows executable metadata.
func get_version(name: StringName, windows_version: bool) -> String:
	pass;

## Returns [code]true[/code] if the preset has the property named [param property].
func has(property: StringName) -> bool:
	pass;

## Returns [code]true[/code] if specified file is exported.
func has_export_file(path: String) -> bool:
	pass;

## Returns [code]true[/code] if dedicated server export mode is selected in the export dialog.
func is_dedicated_server() -> bool:
	pass;

## Returns [code]true[/code] if "Runnable" toggle is enabled in the export dialog.
func is_runnable() -> bool:
	pass;


