extends EditorExportPlatform
class_name EditorExportPlatformExtension

## Base class for custom [EditorExportPlatform] implementations (plugins).
##
## External [EditorExportPlatform] implementations should inherit from this class.
## To use [EditorExportPlatform], register it using the [method EditorPlugin.add_export_platform] method first.





## Returns [code]true[/code], if specified [param preset] is valid and can be exported. Use [method set_config_error] and [method set_config_missing_templates] to set error details.
## Usual implementation can call [method _has_valid_export_configuration] and [method _has_valid_project_configuration] to determine if export is possible.
func _can_export(preset: EditorExportPreset, debug: bool) -> bool:
	pass;

## Called by the editor before platform is unregistered.
func _cleanup() -> void:
	pass;

## Creates a PCK archive at [param path] for the specified [param preset].
## This method is called when "Export PCK/ZIP" button is pressed in the export dialog, with "Export as Patch" disabled, and PCK is selected as a file type.
func _export_pack(preset: EditorExportPreset, debug: bool, path: String, flags: int) -> int:
	pass;

## Creates a patch PCK archive at [param path] for the specified [param preset], containing only the files that have changed since the last patch.
## This method is called when "Export PCK/ZIP" button is pressed in the export dialog, with "Export as Patch" enabled, and PCK is selected as a file type.
## [b]Note:[/b] The patches provided in [param patches] have already been loaded when this method is called and are merely provided as context. When empty the patches defined in the export preset have been loaded instead.
func _export_pack_patch(preset: EditorExportPreset, debug: bool, path: String, patches: PackedStringArray, flags: int) -> int:
	pass;

## Creates a full project at [param path] for the specified [param preset].
## This method is called when "Export" button is pressed in the export dialog.
## This method implementation can call [method EditorExportPlatform.save_pack] or [method EditorExportPlatform.save_zip] to use default PCK/ZIP export process, or calls [method EditorExportPlatform.export_project_files] and implement custom callback for processing each exported file.
func _export_project(preset: EditorExportPreset, debug: bool, path: String, flags: int) -> int:
	pass;

## Create a ZIP archive at [param path] for the specified [param preset].
## This method is called when "Export PCK/ZIP" button is pressed in the export dialog, with "Export as Patch" disabled, and ZIP is selected as a file type.
func _export_zip(preset: EditorExportPreset, debug: bool, path: String, flags: int) -> int:
	pass;

## Create a ZIP archive at [param path] for the specified [param preset], containing only the files that have changed since the last patch.
## This method is called when "Export PCK/ZIP" button is pressed in the export dialog, with "Export as Patch" enabled, and ZIP is selected as a file type.
## [b]Note:[/b] The patches provided in [param patches] have already been loaded when this method is called and are merely provided as context. When empty the patches defined in the export preset have been loaded instead.
func _export_zip_patch(preset: EditorExportPreset, debug: bool, path: String, patches: PackedStringArray, flags: int) -> int:
	pass;

## Returns array of supported binary extensions for the full project export.
func _get_binary_extensions(preset: EditorExportPreset) -> PackedStringArray:
	pass;

## Returns protocol used for remote debugging. Default implementation return [code]tcp://[/code].
func _get_debug_protocol() -> String:
	pass;

## Returns device architecture for one-click deploy.
func _get_device_architecture(device: int) -> String:
	pass;

## Validates [param option] and returns visibility for the specified [param preset]. Default implementation return [code]true[/code] for all options.
func _get_export_option_visibility(preset: EditorExportPreset, option: String) -> bool:
	pass;

## Validates [param option] and returns warning message for the specified [param preset]. Default implementation return empty string for all options.
func _get_export_option_warning(preset: EditorExportPreset, option: StringName) -> String:
	pass;

## Returns a property list, as an [Array] of dictionaries. Each [Dictionary] must at least contain the [code]name: StringName[/code] and [code]type: Variant.Type[/code] entries.
## Additionally, the following keys are supported:
## - [code]hint: PropertyHint[/code]
## - [code]hint_string: String[/code]
## - [code]usage: PropertyUsageFlags[/code]
## - [code]class_name: StringName[/code]
## - [code]default_value: Variant[/code], default value of the property.
## - [code]update_visibility: bool[/code], if set to [code]true[/code], [method _get_export_option_visibility] is called for each property when this property is changed.
## - [code]required: bool[/code], if set to [code]true[/code], this property warnings are critical, and should be resolved to make export possible. This value is a hint for the [method _has_valid_export_configuration] implementation, and not used by the engine directly.
## See also [method Object._get_property_list].
func _get_export_options() -> Array[Dictionary]:
	pass;

## Returns platform logo displayed in the export dialog, logo should be 32x32 adjusted to the current editor scale, see [method EditorInterface.get_editor_scale].
func _get_logo() -> Texture2D:
	pass;

## Returns export platform name.
func _get_name() -> String:
	pass;

## Returns one-click deploy menu item icon for the specified [param device], icon should be 16x16 adjusted to the current editor scale, see [method EditorInterface.get_editor_scale].
func _get_option_icon(device: int) -> ImageTexture:
	pass;

## Returns one-click deploy menu item label for the specified [param device].
func _get_option_label(device: int) -> String:
	pass;

## Returns one-click deploy menu item tooltip for the specified [param device].
func _get_option_tooltip(device: int) -> String:
	pass;

## Returns number one-click deploy devices (or other one-click option displayed in the menu).
func _get_options_count() -> int:
	pass;

## Returns tooltip of the one-click deploy menu button.
func _get_options_tooltip() -> String:
	pass;

## Returns target OS name.
func _get_os_name() -> String:
	pass;

## Returns array of platform specific features.
func _get_platform_features() -> PackedStringArray:
	pass;

## Returns array of platform specific features for the specified [param preset].
func _get_preset_features(preset: EditorExportPreset) -> PackedStringArray:
	pass;

## Returns icon of the one-click deploy menu button, icon should be 16x16 adjusted to the current editor scale, see [method EditorInterface.get_editor_scale].
func _get_run_icon() -> Texture2D:
	pass;

## Returns [code]true[/code] if export configuration is valid.
func _has_valid_export_configuration(preset: EditorExportPreset, debug: bool) -> bool:
	pass;

## Returns [code]true[/code] if project configuration is valid.
func _has_valid_project_configuration(preset: EditorExportPreset) -> bool:
	pass;

## Returns [code]true[/code] if specified file is a valid executable (native executable or script) for the target platform.
func _is_executable(path: String) -> bool:
	pass;

## Returns [code]true[/code] if one-click deploy options are changed and editor interface should be updated.
func _poll_export() -> bool:
	pass;

## This method is called when [param device] one-click deploy menu option is selected.
## Implementation should export project to a temporary location, upload and run it on the specific [param device], or perform another action associated with the menu item.
func _run(preset: EditorExportPreset, device: int, debug_flags: int) -> int:
	pass;

## Returns [code]true[/code] if export options list is changed and presets should be updated.
func _should_update_export_options() -> bool:
	pass;

## Returns current configuration error message text. This method should be called only from the [method _can_export], [method _has_valid_export_configuration], or [method _has_valid_project_configuration] implementations.
func get_config_error() -> String:
	pass;

## Returns [code]true[/code] is export templates are missing from the current configuration. This method should be called only from the [method _can_export], [method _has_valid_export_configuration], or [method _has_valid_project_configuration] implementations.
func get_config_missing_templates() -> bool:
	pass;

## Sets current configuration error message text. This method should be called only from the [method _can_export], [method _has_valid_export_configuration], or [method _has_valid_project_configuration] implementations.
func set_config_error(error_text: String) -> void:
	pass;

## Set to [code]true[/code] is export templates are missing from the current configuration. This method should be called only from the [method _can_export], [method _has_valid_export_configuration], or [method _has_valid_project_configuration] implementations.
func set_config_missing_templates(missing_templates: bool) -> void:
	pass;


