extends BoneConstraint3D
class_name CopyTransformModifier3D

## A [SkeletonModifier3D] that apply transform to the bone which copied from reference.
##
## Apply the copied transform of the bone set by [method BoneConstraint3D.set_reference_bone] to the bone set by [method BoneConstraint3D.set_apply_bone] with processing it with some masks and options.
## There are 4 ways to apply the transform, depending on the combination of [method set_relative] and [method set_additive].
## [b]Relative + Additive:[/b]
## - Extract reference pose relative to the rest and add it to the apply bone's pose.
## [b]Relative + Not Additive:[/b]
## - Extract reference pose relative to the rest and add it to the apply bone's rest.
## [b]Not Relative + Additive:[/b]
## - Extract reference pose absolutely and add it to the apply bone's pose.
## [b]Not Relative + Not Additive:[/b]
## - Extract reference pose absolutely and the apply bone's pose is replaced with it.


## If set, allows to copy the position.
## If set, allows to copy the rotation.
## If set, allows to copy the scale.
## If set, allows to copy the position/rotation/scale.
## If set, allows to process the X-axis.
## If set, allows to process the Y-axis.
## If set, allows to process the Z-axis.
## If set, allows to process the all axes.

#enum TransformFlag
enum {
    TRANSFORM_FLAG_POSITION = 1,
    TRANSFORM_FLAG_ROTATION = 2,
    TRANSFORM_FLAG_SCALE = 4,
    TRANSFORM_FLAG_ALL = 7,
}
#enum AxisFlag
enum {
    AXIS_FLAG_X = 1,
    AXIS_FLAG_Y = 2,
    AXIS_FLAG_Z = 4,
    AXIS_FLAG_ALL = 7,
}
## The number of settings in the modifier.
var setting_count: int:
	get = get_setting_count, set = set_setting_count



## Returns the axis flags of the setting at [param index].
func get_axis_flags(index: int) -> int:
	pass;

## Returns the copy flags of the setting at [param index].
func get_copy_flags(index: int) -> int:
	pass;

## Returns the invert flags of the setting at [param index].
func get_invert_flags(index: int) -> int:
	pass;

## Returns [code]true[/code] if the additive option is enabled in the setting at [param index].
func is_additive(index: int) -> bool:
	pass;

## Returns [code]true[/code] if the enable flags has the flag for the X-axis in the setting at [param index]. See also [method set_axis_flags].
func is_axis_x_enabled(index: int) -> bool:
	pass;

## Returns [code]true[/code] if the invert flags has the flag for the X-axis in the setting at [param index]. See also [method set_invert_flags].
func is_axis_x_inverted(index: int) -> bool:
	pass;

## Returns [code]true[/code] if the enable flags has the flag for the Y-axis in the setting at [param index]. See also [method set_axis_flags].
func is_axis_y_enabled(index: int) -> bool:
	pass;

## Returns [code]true[/code] if the invert flags has the flag for the Y-axis in the setting at [param index]. See also [method set_invert_flags].
func is_axis_y_inverted(index: int) -> bool:
	pass;

## Returns [code]true[/code] if the enable flags has the flag for the Z-axis in the setting at [param index]. See also [method set_axis_flags].
func is_axis_z_enabled(index: int) -> bool:
	pass;

## Returns [code]true[/code] if the invert flags has the flag for the Z-axis in the setting at [param index]. See also [method set_invert_flags].
func is_axis_z_inverted(index: int) -> bool:
	pass;

## Returns [code]true[/code] if the copy flags has the flag for the position in the setting at [param index]. See also [method set_copy_flags].
func is_position_copying(index: int) -> bool:
	pass;

## Returns [code]true[/code] if the relative option is enabled in the setting at [param index].
func is_relative(index: int) -> bool:
	pass;

## Returns [code]true[/code] if the copy flags has the flag for the rotation in the setting at [param index]. See also [method set_copy_flags].
func is_rotation_copying(index: int) -> bool:
	pass;

## Returns [code]true[/code] if the copy flags has the flag for the scale in the setting at [param index]. See also [method set_copy_flags].
func is_scale_copying(index: int) -> bool:
	pass;

## Sets additive option in the setting at [param index] to [param enabled]. This mainly affects the process of applying transform to the [method BoneConstraint3D.set_apply_bone].
## If sets [param enabled] to [code]true[/code], the processed transform is added to the pose of the current apply bone.
## If sets [param enabled] to [code]false[/code], the pose of the current apply bone is replaced with the processed transform. However, if set [method set_relative] to [code]true[/code], the transform is relative to rest.
func set_additive(index: int, enabled: bool) -> void:
	pass;

## Sets the flags to copy axes. If the flag is valid, the axis is copied.
func set_axis_flags(index: int, axis_flags: int) -> void:
	pass;

## If sets [param enabled] to [code]true[/code], the X-axis will be copied.
func set_axis_x_enabled(index: int, enabled: bool) -> void:
	pass;

## If sets [param enabled] to [code]true[/code], the X-axis will be inverted.
func set_axis_x_inverted(index: int, enabled: bool) -> void:
	pass;

## If sets [param enabled] to [code]true[/code], the Y-axis will be copied.
func set_axis_y_enabled(index: int, enabled: bool) -> void:
	pass;

## If sets [param enabled] to [code]true[/code], the Y-axis will be inverted.
func set_axis_y_inverted(index: int, enabled: bool) -> void:
	pass;

## If sets [param enabled] to [code]true[/code], the Z-axis will be copied.
func set_axis_z_enabled(index: int, enabled: bool) -> void:
	pass;

## If sets [param enabled] to [code]true[/code], the Z-axis will be inverted.
func set_axis_z_inverted(index: int, enabled: bool) -> void:
	pass;

## Sets the flags to process the transform operations. If the flag is valid, the transform operation is processed.
## [b]Note:[/b] If the rotation is valid for only one axis, it respects the roll of the valid axis. If the rotation is valid for two axes, it discards the roll of the invalid axis.
func set_copy_flags(index: int, copy_flags: int) -> void:
	pass;

## If sets [param enabled] to [code]true[/code], the position will be copied.
func set_copy_position(index: int, enabled: bool) -> void:
	pass;

## If sets [param enabled] to [code]true[/code], the rotation will be copied.
func set_copy_rotation(index: int, enabled: bool) -> void:
	pass;

## If sets [param enabled] to [code]true[/code], the scale will be copied.
func set_copy_scale(index: int, enabled: bool) -> void:
	pass;

## Sets the flags to inverte axes. If the flag is valid, the axis is copied.
## [b]Note:[/b] An inverted scale means an inverse number, not a negative scale. For example, inverting [code]2.0[/code] means [code]0.5[/code].
## [b]Note:[/b] An inverted rotation flips the elements of the quaternion. For example, a two-axis inversion will flip the roll of each axis, and a three-axis inversion will flip the final orientation. However, be aware that flipping only one axis may cause unintended rotation by the unflipped axes, due to the characteristics of the quaternion.
func set_invert_flags(index: int, axis_flags: int) -> void:
	pass;

## Sets relative option in the setting at [param index] to [param enabled].
## If sets [param enabled] to [code]true[/code], the extracted and applying transform is relative to the rest.
## If sets [param enabled] to [code]false[/code], the extracted transform is absolute.
func set_relative(index: int, enabled: bool) -> void:
	pass;


func get_setting_count() -> int:
	return setting_count

func set_setting_count(value: int) -> void:
	setting_count = value

