extends BoneConstraint3D
class_name ConvertTransformModifier3D

## A [SkeletonModifier3D] that apply transform to the bone which converted from reference.
##
## Apply the copied transform of the bone set by [method BoneConstraint3D.set_reference_bone] to the bone set by [method BoneConstraint3D.set_apply_bone] about the specific axis with remapping it with some options.
## There are 4 ways to apply the transform, depending on the combination of [method set_relative] and [method set_additive].
## [b]Relative + Additive:[/b]
## - Extract reference pose relative to the rest and add it to the apply bone's pose.
## [b]Relative + Not Additive:[/b]
## - Extract reference pose relative to the rest and add it to the apply bone's rest.
## [b]Not Relative + Additive:[/b]
## - Extract reference pose absolutely and add it to the apply bone's pose.
## [b]Not Relative + Not Additive:[/b]
## - Extract reference pose absolutely and the apply bone's pose is replaced with it.


## Convert with position. Transfer the difference.
## Convert with rotation. The angle is the roll for the specified axis.
## Convert with scale. Transfers the ratio, not the difference.

#enum TransformMode
enum {
    TRANSFORM_MODE_POSITION = 0,
    TRANSFORM_MODE_ROTATION = 1,
    TRANSFORM_MODE_SCALE = 2,
}
## The number of settings in the modifier.
var setting_count: int:
	get = get_setting_count, set = set_setting_count



## Returns the axis of the remapping destination transform.
func get_apply_axis(index: int) -> int:
	pass;

## Returns the maximum value of the remapping destination range.
func get_apply_range_max(index: int) -> float:
	pass;

## Returns the minimum value of the remapping destination range.
func get_apply_range_min(index: int) -> float:
	pass;

## Returns the operation of the remapping destination transform.
func get_apply_transform_mode(index: int) -> int:
	pass;

## Returns the axis of the remapping source transform.
func get_reference_axis(index: int) -> int:
	pass;

## Returns the maximum value of the remapping source range.
func get_reference_range_max(index: int) -> float:
	pass;

## Returns the minimum value of the remapping source range.
func get_reference_range_min(index: int) -> float:
	pass;

## Returns the operation of the remapping source transform.
func get_reference_transform_mode(index: int) -> int:
	pass;

## Returns [code]true[/code] if the additive option is enabled in the setting at [param index].
func is_additive(index: int) -> bool:
	pass;

## Returns [code]true[/code] if the relative option is enabled in the setting at [param index].
func is_relative(index: int) -> bool:
	pass;

## Sets additive option in the setting at [param index] to [param enabled]. This mainly affects the process of applying transform to the [method BoneConstraint3D.set_apply_bone].
## If sets [param enabled] to [code]true[/code], the processed transform is added to the pose of the current apply bone.
## If sets [param enabled] to [code]false[/code], the pose of the current apply bone is replaced with the processed transform. However, if set [method set_relative] to [code]true[/code], the transform is relative to rest.
func set_additive(index: int, enabled: bool) -> void:
	pass;

## Sets the axis of the remapping destination transform.
func set_apply_axis(index: int, axis: int) -> void:
	pass;

## Sets the maximum value of the remapping destination range.
func set_apply_range_max(index: int, range_max: float) -> void:
	pass;

## Sets the minimum value of the remapping destination range.
func set_apply_range_min(index: int, range_min: float) -> void:
	pass;

## Sets the operation of the remapping destination transform.
func set_apply_transform_mode(index: int, transform_mode: int) -> void:
	pass;

## Sets the axis of the remapping source transform.
func set_reference_axis(index: int, axis: int) -> void:
	pass;

## Sets the maximum value of the remapping source range.
func set_reference_range_max(index: int, range_max: float) -> void:
	pass;

## Sets the minimum value of the remapping source range.
func set_reference_range_min(index: int, range_min: float) -> void:
	pass;

## Sets the operation of the remapping source transform.
func set_reference_transform_mode(index: int, transform_mode: int) -> void:
	pass;

## Sets relative option in the setting at [param index] to [param enabled].
## If sets [param enabled] to [code]true[/code], the extracted and applying transform is relative to the rest.
## If sets [param enabled] to [code]false[/code], the extracted transform is absolute.
func set_relative(index: int, enabled: bool) -> void:
	pass;


func get_setting_count() -> int:
	return setting_count

func set_setting_count(value: int) -> void:
	setting_count = value

