extends Shape3D
class_name CapsuleShape3D

## A 3D capsule shape used for physics collision.
##
## A 3D capsule shape, intended for use in physics. Usually used to provide a shape for a [CollisionShape3D].
## [b]Performance:[/b] [CapsuleShape3D] is fast to check collisions against. It is faster than [CylinderShape3D], but slower than [SphereShape3D] and [BoxShape3D].
##
## @tutorial(3D Physics Tests Demo): https://godotengine.org/asset-library/asset/2747



## The capsule's full height, including the hemispheres.
var height: float:
	get = get_height, set = set_height

## The capsule's height, excluding the hemispheres. This is the height of the central cylindrical part in the middle of the capsule, and is the distance between the centers of the two hemispheres. This is a wrapper for [member height].
var mid_height: float:
	get = get_mid_height, set = set_mid_height

## The capsule's radius.
var radius: float:
	get = get_radius, set = set_radius




func get_height() -> float:
	return height

func set_height(value: float) -> void:
	height = value

func get_mid_height() -> float:
	return mid_height

func set_mid_height(value: float) -> void:
	mid_height = value

func get_radius() -> float:
	return radius

func set_radius(value: float) -> void:
	radius = value

