extends Shape2D
class_name CapsuleShape2D

## A 2D capsule shape used for physics collision.
##
## A 2D capsule shape, intended for use in physics. Usually used to provide a shape for a [CollisionShape2D].
## [b]Performance:[/b] [CapsuleShape2D] is fast to check collisions against, but it is slower than [RectangleShape2D] and [CircleShape2D].



## The capsule's full height, including the semicircles.
var height: float:
	get = get_height, set = set_height

## The capsule's height, excluding the semicircles. This is the height of the central rectangular part in the middle of the capsule, and is the distance between the centers of the two semicircles. This is a wrapper for [member height].
var mid_height: float:
	get = get_mid_height, set = set_mid_height

## The capsule's radius.
var radius: float:
	get = get_radius, set = set_radius




func get_height() -> float:
	return height

func set_height(value: float) -> void:
	height = value

func get_mid_height() -> float:
	return mid_height

func set_mid_height(value: float) -> void:
	mid_height = value

func get_radius() -> float:
	return radius

func set_radius(value: float) -> void:
	radius = value

