extends Object
class_name CameraServer

## Server keeping track of different cameras accessible in Godot.
##
## The [CameraServer] keeps track of different cameras accessible in Godot. These are external cameras such as webcams or the cameras on your phone.
## It is notably used to provide AR modules with a video feed from the camera.
## [b]Note:[/b] This class is currently only implemented on Linux, Android, macOS, and iOS. On other platforms no [CameraFeed]s will be available. To get a [CameraFeed] on iOS, the camera plugin from [url=https://github.com/godotengine/godot-ios-plugins]godot-ios-plugins[/url] is required.


## Emitted when a [CameraFeed] is added (e.g. a webcam is plugged in).
signal camera_feed_added(id: int)
## Emitted when a [CameraFeed] is removed (e.g. a webcam is unplugged).
signal camera_feed_removed(id: int)
## The RGBA camera image.
## The [url=https://en.wikipedia.org/wiki/YCbCr]YCbCr[/url] camera image.
## The Y component camera image.
## The CbCr component camera image.

#enum FeedImage
enum {
    FEED_RGBA_IMAGE = 0,
    FEED_YCBCR_IMAGE = 0,
    FEED_Y_IMAGE = 0,
    FEED_CBCR_IMAGE = 1,
}
## If [code]true[/code], the server is actively monitoring available camera feeds.
## This has a performance cost, so only set it to [code]true[/code] when you're actively accessing the camera.
var monitoring_feeds: bool:
	get = is_monitoring_feeds, set = set_monitoring_feeds



## Adds the camera [param feed] to the camera server.
func add_feed(feed: CameraFeed) -> void:
	pass;

## Returns an array of [CameraFeed]s.
func feeds() -> Array[CameraFeed]:
	pass;

## Returns the [CameraFeed] corresponding to the camera with the given [param index].
func get_feed(index: int) -> CameraFeed:
	pass;

## Returns the number of [CameraFeed]s registered.
func get_feed_count() -> int:
	pass;

## Removes the specified camera [param feed].
func remove_feed(feed: CameraFeed) -> void:
	pass;


func is_monitoring_feeds() -> bool:
	return monitoring_feeds

func set_monitoring_feeds(value: bool) -> void:
	monitoring_feeds = value

