extends RefCounted
class_name CameraFeed

## A camera feed gives you access to a single physical camera attached to your device.
##
## A camera feed gives you access to a single physical camera attached to your device. When enabled, Godot will start capturing frames from the camera which can then be used. See also [CameraServer].
## [b]Note:[/b] Many cameras will return YCbCr images which are split into two textures and need to be combined in a shader. Godot does this automatically for you if you set the environment to show the camera image in the background.
## [b]Note:[/b] This class is currently only implemented on Linux, Android, macOS, and iOS. On other platforms no [CameraFeed]s will be available. To get a [CameraFeed] on iOS, the camera plugin from [url=https://github.com/godotengine/godot-ios-plugins]godot-ios-plugins[/url] is required.


## Emitted when the format has changed.
signal format_changed
## Emitted when a new frame is available.
signal frame_changed
## No image set for the feed.
## Feed supplies RGB images.
## Feed supplies YCbCr images that need to be converted to RGB.
## Feed supplies separate Y and CbCr images that need to be combined and converted to RGB.
## Feed supplies external image.
## Unspecified position.
## Camera is mounted at the front of the device.
## Camera is mounted at the back of the device.

#enum FeedDataType
enum {
    FEED_NOIMAGE = 0,
    FEED_RGB = 1,
    FEED_YCBCR = 2,
    FEED_YCBCR_SEP = 3,
    FEED_EXTERNAL = 4,
}
#enum FeedPosition
enum {
    FEED_UNSPECIFIED = 0,
    FEED_FRONT = 1,
    FEED_BACK = 2,
}
## If [code]true[/code], the feed is active.
var feed_is_active: bool:
	get = is_active, set = set_active

## The transform applied to the camera's image.
var feed_transform: Transform2D:
	get = get_transform, set = set_transform

## Formats supported by the feed. Each entry is a [Dictionary] describing format parameters.
var formats: Array:
	get = get_formats



## Called when the camera feed is activated.
func _activate_feed() -> bool:
	pass;

## Called when the camera feed is deactivated.
func _deactivate_feed() -> void:
	pass;

## Returns feed image data type.
func get_datatype() -> int:
	pass;

## Returns the unique ID for this feed.
func get_id() -> int:
	pass;

## Returns the camera's name.
func get_name() -> String:
	pass;

## Returns the position of camera on the device.
func get_position() -> int:
	pass;

## Returns the texture backend ID (usable by some external libraries that need a handle to a texture to write data).
func get_texture_tex_id(feed_image_type: int) -> int:
	pass;

## Sets the feed as external feed provided by another library.
func set_external(width: int, height: int) -> void:
	pass;

## Sets the feed format parameters for the given index in the [member formats] array. Returns [code]true[/code] on success. By default YUYV encoded stream is transformed to FEED_RGB. YUYV encoded stream output format can be changed with [param parameters].output value:
## [code]separate[/code] will result in FEED_YCBCR_SEP
## [code]grayscale[/code] will result in desaturated FEED_RGB
## [code]copy[/code] will result in FEED_YCBCR
func set_format(index: int, parameters: Dictionary) -> bool:
	pass;

## Sets the camera's name.
func set_name(name: String) -> void:
	pass;

## Sets the position of this camera.
func set_position(position: int) -> void:
	pass;

## Sets RGB image for this feed.
func set_rgb_image(rgb_image: Image) -> void:
	pass;

## Sets YCbCr image for this feed.
func set_ycbcr_image(ycbcr_image: Image) -> void:
	pass;


func is_active() -> bool:
	return feed_is_active

func set_active(value: bool) -> void:
	feed_is_active = value

func get_transform() -> Transform2D:
	return feed_transform

func set_transform(value: Transform2D) -> void:
	feed_transform = value

func get_formats() -> Array:
	return formats

