extends SkeletonModifier3D
class_name BoneConstraint3D

## A node that may modify Skeleton3D's bone with associating the two bones.
##
## Base class of [SkeletonModifier3D] that modifies the bone set in [method set_apply_bone] based on the transform of the bone retrieved by [method get_reference_bone].





## Clear all settings.
func clear_setting() -> void:
	pass;

## Returns the apply amount of the setting at [param index].
func get_amount(index: int) -> float:
	pass;

## Returns the apply bone of the setting at [param index]. This bone will be modified.
func get_apply_bone(index: int) -> int:
	pass;

## Returns the apply bone name of the setting at [param index]. This bone will be modified.
func get_apply_bone_name(index: int) -> String:
	pass;

## Returns the reference bone of the setting at [param index].
## This bone will be only referenced and not modified by this modifier.
func get_reference_bone(index: int) -> int:
	pass;

## Returns the reference bone name of the setting at [param index].
## This bone will be only referenced and not modified by this modifier.
func get_reference_bone_name(index: int) -> String:
	pass;

## Returns the number of settings in the modifier.
func get_setting_count() -> int:
	pass;

## Sets the apply amount of the setting at [param index] to [param amount].
func set_amount(index: int, amount: float) -> void:
	pass;

## Sets the apply bone of the setting at [param index] to [param bone]. This bone will be modified.
func set_apply_bone(index: int, bone: int) -> void:
	pass;

## Sets the apply bone of the setting at [param index] to [param bone_name]. This bone will be modified.
func set_apply_bone_name(index: int, bone_name: String) -> void:
	pass;

## Sets the reference bone of the setting at [param index] to [param bone].
## This bone will be only referenced and not modified by this modifier.
func set_reference_bone(index: int, bone: int) -> void:
	pass;

## Sets the reference bone of the setting at [param index] to [param bone_name].
## This bone will be only referenced and not modified by this modifier.
func set_reference_bone_name(index: int, bone_name: String) -> void:
	pass;

## Sets the number of settings in the modifier.
func set_setting_count(count: int) -> void:
	pass;


