extends Node3D
class_name BoneAttachment3D

## А node that dynamically copies or overrides the 3D transform of a bone in its parent [Skeleton3D].
##
## This node selects a bone in a [Skeleton3D] and attaches to it. This means that the [BoneAttachment3D] node will either dynamically copy or override the 3D transform of the selected bone.



## The index of the attached bone.
var bone_idx: int:
	get = get_bone_idx, set = set_bone_idx

## The name of the attached bone.
var bone_name: String:
	get = get_bone_name, set = set_bone_name

## The [NodePath] to the external [Skeleton3D] node.
var external_skeleton: NodePath:
	get = get_external_skeleton, set = set_external_skeleton

## Whether the [BoneAttachment3D] node will override the bone pose of the bone it is attached to. When set to [code]true[/code], the [BoneAttachment3D] node can change the pose of the bone. When set to [code]false[/code], the [BoneAttachment3D] will always be set to the bone's transform.
## [b]Note:[/b] This override performs interruptively in the skeleton update process using signals due to the old design. It may cause unintended behavior when used at the same time with [SkeletonModifier3D].
var override_pose: bool:
	get = get_override_pose, set = set_override_pose

var physics_interpolation_mode: int:
	get = get_physics_interpolation_mode, set = set_physics_interpolation_mode

## Whether the [BoneAttachment3D] node will use an external [Skeleton3D] node rather than attempting to use its parent node as the [Skeleton3D]. When set to [code]true[/code], the [BoneAttachment3D] node will use the external [Skeleton3D] node set in [member external_skeleton].
var use_external_skeleton: bool:
	get = get_use_external_skeleton, set = set_use_external_skeleton



## Returns the parent or external [Skeleton3D] node if it exists, otherwise returns [code]null[/code].
func get_skeleton() -> Skeleton3D:
	pass;

## A function that is called automatically when the [Skeleton3D] is updated. This function is where the [BoneAttachment3D] node updates its position so it is correctly bound when it is [i]not[/i] set to override the bone pose.
func on_skeleton_update() -> void:
	pass;


func get_bone_idx() -> int:
	return bone_idx

func set_bone_idx(value: int) -> void:
	bone_idx = value

func get_bone_name() -> String:
	return bone_name

func set_bone_name(value: String) -> void:
	bone_name = value

func get_external_skeleton() -> NodePath:
	return external_skeleton

func set_external_skeleton(value: NodePath) -> void:
	external_skeleton = value

func get_override_pose() -> bool:
	return override_pose

func set_override_pose(value: bool) -> void:
	override_pose = value

func get_physics_interpolation_mode() -> int:
	return physics_interpolation_mode

func set_physics_interpolation_mode(value: int) -> void:
	physics_interpolation_mode = value

func get_use_external_skeleton() -> bool:
	return use_external_skeleton

func set_use_external_skeleton(value: bool) -> void:
	use_external_skeleton = value

